/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import com.carrotsearch.hppc.ObjectArrayList;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Random;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.indices.IndexTemplateMissingException;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;

public abstract class TestCluster
implements Closeable {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    private final long seed;
    protected Random random;
    protected double transportClientRatio = 0.0;

    public TestCluster(long seed) {
        this.seed = seed;
    }

    public long seed() {
        return this.seed;
    }

    public void beforeTest(Random random, double transportClientRatio) throws IOException, InterruptedException {
        assert (transportClientRatio >= 0.0 && transportClientRatio <= 1.0);
        this.logger.debug("Reset test cluster with transport client ratio: [{}]", (Object)transportClientRatio);
        this.transportClientRatio = transportClientRatio;
        this.random = new Random(random.nextLong());
    }

    public void wipe(Set<String> excludeTemplates) {
        this.wipeIndices("_all");
        this.wipeAllTemplates(excludeTemplates);
        this.wipeRepositories(new String[0]);
    }

    public void beforeIndexDeletion() throws Exception {
    }

    public void assertAfterTest() throws IOException {
        this.ensureEstimatedStats();
    }

    public abstract void afterTest() throws IOException;

    public abstract Client client();

    public abstract int size();

    public abstract int numDataNodes();

    public abstract int numDataAndMasterNodes();

    public abstract InetSocketAddress[] httpAddresses();

    @Override
    public abstract void close() throws IOException;

    public void wipeIndices(String ... indices) {
        block6: {
            assert (indices != null && indices.length > 0);
            if (this.size() > 0) {
                try {
                    ElasticsearchAssertions.assertAcked(this.client().admin().indices().prepareDelete(indices).setIndicesOptions(IndicesOptions.fromOptions((boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)false, (boolean)false, (boolean)true, (boolean)false)));
                }
                catch (IndexNotFoundException indexNotFoundException) {
                }
                catch (IllegalArgumentException e) {
                    if (!"_all".equals(indices[0])) break block6;
                    ClusterStateResponse clusterStateResponse = (ClusterStateResponse)this.client().admin().cluster().prepareState().execute().actionGet();
                    ObjectArrayList concreteIndices = new ObjectArrayList();
                    for (IndexMetaData indexMetaData : clusterStateResponse.getState().metaData()) {
                        concreteIndices.add((Object)indexMetaData.getIndex().getName());
                    }
                    if (concreteIndices.isEmpty()) break block6;
                    ElasticsearchAssertions.assertAcked(this.client().admin().indices().prepareDelete((String[])concreteIndices.toArray(String.class)));
                }
            }
        }
    }

    public void wipeAllTemplates(Set<String> exclude) {
        if (this.size() > 0) {
            GetIndexTemplatesResponse response = (GetIndexTemplatesResponse)this.client().admin().indices().prepareGetTemplates(new String[0]).get();
            for (IndexTemplateMetaData indexTemplate : response.getIndexTemplates()) {
                if (exclude.contains(indexTemplate.getName())) continue;
                try {
                    this.client().admin().indices().prepareDeleteTemplate(indexTemplate.getName()).execute().actionGet();
                }
                catch (IndexTemplateMissingException indexTemplateMissingException) {}
            }
        }
    }

    public void wipeTemplates(String ... templates) {
        if (this.size() > 0) {
            if (templates.length == 0) {
                templates = new String[]{"*"};
            }
            for (String template : templates) {
                try {
                    this.client().admin().indices().prepareDeleteTemplate(template).execute().actionGet();
                }
                catch (IndexTemplateMissingException indexTemplateMissingException) {
                    // empty catch block
                }
            }
        }
    }

    public void wipeRepositories(String ... repositories) {
        if (this.size() > 0) {
            if (repositories.length == 0) {
                repositories = new String[]{"*"};
            }
            for (String repository : repositories) {
                try {
                    this.client().admin().cluster().prepareDeleteRepository(repository).execute().actionGet();
                }
                catch (RepositoryMissingException repositoryMissingException) {
                    // empty catch block
                }
            }
        }
    }

    public abstract void ensureEstimatedStats();

    public abstract String getClusterName();

    public abstract Iterable<Client> getClients();

    public abstract NamedWriteableRegistry getNamedWriteableRegistry();
}

