/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.section;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.client.HasAttributeNodeSelector;
import org.elasticsearch.client.Node;
import org.elasticsearch.client.NodeSelector;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentLocation;
import org.elasticsearch.common.xcontent.XContentParseException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.test.hamcrest.RegexMatcher;
import org.elasticsearch.test.rest.yaml.ClientYamlTestExecutionContext;
import org.elasticsearch.test.rest.yaml.ClientYamlTestResponse;
import org.elasticsearch.test.rest.yaml.ClientYamlTestResponseException;
import org.elasticsearch.test.rest.yaml.section.ApiCallSection;
import org.elasticsearch.test.rest.yaml.section.ExecutableSection;
import org.elasticsearch.test.rest.yaml.section.SkipSection;
import org.elasticsearch.test.rest.yaml.section.VersionRange;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class DoSection
implements ExecutableSection {
    private static final Logger logger = LogManager.getLogger(DoSection.class);
    private final XContentLocation location;
    private String catchParam;
    private ApiCallSection apiCallSection;
    private List<String> expectedWarningHeaders = Collections.emptyList();
    private List<String> allowedWarningHeaders = Collections.emptyList();
    private static Map<String, Tuple<String, org.hamcrest.Matcher<Integer>>> catches = new HashMap<String, Tuple<String, org.hamcrest.Matcher<Integer>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DoSection parse(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        DoSection doSection = new DoSection(parser.getTokenLocation());
        ApiCallSection apiCallSection = null;
        NodeSelector nodeSelector = NodeSelector.ANY;
        TreeMap<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        ArrayList<String> expectedWarnings = new ArrayList<String>();
        ArrayList<String> allowedWarnings = new ArrayList<String>();
        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("expected [" + XContentParser.Token.START_OBJECT + "], found [" + parser.currentToken() + "], the do section is not properly indented");
        }
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if ("catch".equals(currentFieldName)) {
                    doSection.setCatch(parser.text());
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "unsupported field [" + currentFieldName + "]", new Object[0]);
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if ("warnings".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) == XContentParser.Token.VALUE_STRING) {
                        expectedWarnings.add(parser.text());
                    }
                    if (token == XContentParser.Token.END_ARRAY) continue;
                    throw new ParsingException(parser.getTokenLocation(), "[warnings] must be a string array but saw [" + token + "]", new Object[0]);
                }
                if ("allowed_warnings".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) == XContentParser.Token.VALUE_STRING) {
                        allowedWarnings.add(parser.text());
                    }
                    if (token == XContentParser.Token.END_ARRAY) continue;
                    throw new ParsingException(parser.getTokenLocation(), "[allowed_warnings] must be a string array but saw [" + token + "]", new Object[0]);
                }
                throw new ParsingException(parser.getTokenLocation(), "unknown array [" + currentFieldName + "]", new Object[0]);
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            if ("headers".equals(currentFieldName)) {
                String headerName = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        headerName = parser.currentName();
                        continue;
                    }
                    if (!token.isValue()) continue;
                    headers.put(headerName, parser.text());
                }
                continue;
            }
            if ("node_selector".equals(currentFieldName)) {
                String selectorName = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        selectorName = parser.currentName();
                        continue;
                    }
                    NodeSelector newSelector = DoSection.buildNodeSelector(selectorName, parser);
                    nodeSelector = nodeSelector == NodeSelector.ANY ? newSelector : new ComposeNodeSelector(nodeSelector, newSelector);
                }
                continue;
            }
            if (currentFieldName == null) continue;
            apiCallSection = new ApiCallSection(currentFieldName);
            String paramName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    paramName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if ("body".equals(paramName)) {
                        String body = parser.text();
                        XContentParser bodyParser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, body);
                        while (bodyParser.nextToken() != null) {
                            apiCallSection.addBody(bodyParser.mapOrdered());
                        }
                        continue;
                    }
                    apiCallSection.addParam(paramName, parser.text());
                    continue;
                }
                if (token != XContentParser.Token.START_OBJECT || !"body".equals(paramName)) continue;
                apiCallSection.addBody(parser.mapOrdered());
            }
        }
        try {
            if (apiCallSection == null) {
                throw new IllegalArgumentException("client call section is mandatory within a do section");
            }
            for (String w : expectedWarnings) {
                if (!allowedWarnings.contains(w)) continue;
                throw new IllegalArgumentException("the warning [" + w + "] was both allowed and expected");
            }
            apiCallSection.addHeaders(headers);
            apiCallSection.setNodeSelector(nodeSelector);
            doSection.setApiCallSection(apiCallSection);
            doSection.setExpectedWarningHeaders(Collections.unmodifiableList(expectedWarnings));
            doSection.setAllowedWarningHeaders(Collections.unmodifiableList(allowedWarnings));
        }
        finally {
            parser.nextToken();
        }
        return doSection;
    }

    public DoSection(XContentLocation location) {
        this.location = location;
    }

    public String getCatch() {
        return this.catchParam;
    }

    public void setCatch(String catchParam) {
        this.catchParam = catchParam;
    }

    public ApiCallSection getApiCallSection() {
        return this.apiCallSection;
    }

    void setApiCallSection(ApiCallSection apiCallSection) {
        this.apiCallSection = apiCallSection;
    }

    List<String> getExpectedWarningHeaders() {
        return this.expectedWarningHeaders;
    }

    void setExpectedWarningHeaders(List<String> expectedWarningHeaders) {
        this.expectedWarningHeaders = expectedWarningHeaders;
    }

    List<String> getAllowedWarningHeaders() {
        return this.allowedWarningHeaders;
    }

    void setAllowedWarningHeaders(List<String> allowedWarningHeaders) {
        this.allowedWarningHeaders = allowedWarningHeaders;
    }

    @Override
    public XContentLocation getLocation() {
        return this.location;
    }

    @Override
    public void execute(ClientYamlTestExecutionContext executionContext) throws IOException {
        if ("param".equals(this.catchParam)) {
            logger.info("found [catch: param], no request sent");
            return;
        }
        try {
            ClientYamlTestResponse response = executionContext.callApi(this.apiCallSection.getApi(), this.apiCallSection.getParams(), this.apiCallSection.getBodies(), this.apiCallSection.getHeaders(), this.apiCallSection.getNodeSelector());
            if (Strings.hasLength((String)this.catchParam)) {
                String catchStatusCode;
                if (catches.containsKey(this.catchParam)) {
                    catchStatusCode = (String)catches.get(this.catchParam).v1();
                } else if (this.catchParam.startsWith("/") && this.catchParam.endsWith("/")) {
                    catchStatusCode = "4xx|5xx";
                } else {
                    throw new UnsupportedOperationException("catch value [" + this.catchParam + "] not supported");
                }
                Assert.fail((String)this.formatStatusCodeMessage(response, catchStatusCode));
            }
            this.checkWarningHeaders(response.getWarningHeaders(), executionContext.masterVersion());
        }
        catch (ClientYamlTestResponseException e) {
            ClientYamlTestResponse restTestResponse = e.getRestTestResponse();
            if (!Strings.hasLength((String)this.catchParam)) {
                Assert.fail((String)this.formatStatusCodeMessage(restTestResponse, "2xx"));
            }
            if (catches.containsKey(this.catchParam)) {
                this.assertStatusCode(restTestResponse);
            }
            if (this.catchParam.length() > 2 && this.catchParam.startsWith("/") && this.catchParam.endsWith("/")) {
                Assert.assertThat((String)this.formatStatusCodeMessage(restTestResponse, "4xx|5xx"), (Object)e.getResponseException().getResponse().getStatusLine().getStatusCode(), (org.hamcrest.Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(400)));
                Object error = executionContext.response("error");
                Assert.assertThat((String)"error was expected in the response", (Object)error, (org.hamcrest.Matcher)Matchers.notNullValue());
                String regex = this.catchParam.substring(1, this.catchParam.length() - 1);
                Assert.assertThat((String)"the error message was expected to match the provided regex but didn't", (Object)error.toString(), (org.hamcrest.Matcher)RegexMatcher.matches(regex));
            }
            throw new UnsupportedOperationException("catch value [" + this.catchParam + "] not supported");
        }
    }

    void checkWarningHeaders(List<String> warningHeaders, Version masterVersion) {
        ArrayList<String> unexpected = new ArrayList<String>();
        ArrayList<String> unmatched = new ArrayList<String>();
        ArrayList<String> missing = new ArrayList<String>();
        Set allowed = this.allowedWarningHeaders.stream().map(DeprecationLogger::escapeAndEncode).collect(Collectors.toSet());
        Set expected = this.expectedWarningHeaders.stream().map(DeprecationLogger::escapeAndEncode).collect(Collectors.toCollection(LinkedHashSet::new));
        for (String header : warningHeaders) {
            Matcher matcher = DeprecationLogger.WARNING_HEADER_PATTERN.matcher(header);
            boolean matches = matcher.matches();
            if (matches) {
                String message = DeprecationLogger.extractWarningValueFromWarningHeader((String)header, (boolean)true);
                if (masterVersion.before(Version.V_7_0_0) && message.equals("the default number of shards will change from [5] to [1] in 7.0.0; if you wish to continue using the default of [5] shards, you must manage this on the create index request or with an index template") || message.startsWith("[types removal]") || allowed.contains(message) || expected.remove(message)) continue;
                unexpected.add(header);
                continue;
            }
            unmatched.add(header);
        }
        if (!expected.isEmpty()) {
            for (String header : expected) {
                missing.add(header);
            }
        }
        if (!(unexpected.isEmpty() && unmatched.isEmpty() && missing.isEmpty())) {
            StringBuilder failureMessage = new StringBuilder();
            this.appendBadHeaders(failureMessage, unexpected, "got unexpected warning header" + (unexpected.size() > 1 ? "s" : ""));
            this.appendBadHeaders(failureMessage, unmatched, "got unmatched warning header" + (unmatched.size() > 1 ? "s" : ""));
            this.appendBadHeaders(failureMessage, missing, "did not get expected warning header" + (missing.size() > 1 ? "s" : ""));
            Assert.fail((String)failureMessage.toString());
        }
    }

    private void appendBadHeaders(StringBuilder sb, List<String> headers, String message) {
        if (!headers.isEmpty()) {
            sb.append(message).append(" [\n");
            for (String header : headers) {
                sb.append("\t").append(header).append("\n");
            }
            sb.append("]\n");
        }
    }

    private void assertStatusCode(ClientYamlTestResponse restTestResponse) {
        Tuple<String, org.hamcrest.Matcher<Integer>> stringMatcherTuple = catches.get(this.catchParam);
        Assert.assertThat((String)this.formatStatusCodeMessage(restTestResponse, (String)stringMatcherTuple.v1()), (Object)restTestResponse.getStatusCode(), (org.hamcrest.Matcher)((org.hamcrest.Matcher)stringMatcherTuple.v2()));
    }

    private String formatStatusCodeMessage(ClientYamlTestResponse restTestResponse, String expected) {
        String api = this.apiCallSection.getApi();
        if ("raw".equals(api)) {
            api = api + "[method=" + this.apiCallSection.getParams().get("method") + " path=" + this.apiCallSection.getParams().get("path") + "]";
        }
        return "expected [" + expected + "] status code but api [" + api + "] returned [" + restTestResponse.getStatusCode() + " " + restTestResponse.getReasonPhrase() + "] [" + restTestResponse.getBodyAsString() + "]";
    }

    private static NodeSelector buildNodeSelector(String name, XContentParser parser) throws IOException {
        switch (name) {
            case "attribute": {
                return DoSection.parseAttributeValuesSelector(parser);
            }
            case "version": {
                return DoSection.parseVersionSelector(parser);
            }
        }
        throw new XContentParseException(parser.getTokenLocation(), "unknown node_selector [" + name + "]");
    }

    private static NodeSelector parseAttributeValuesSelector(XContentParser parser) throws IOException {
        XContentParser.Token token;
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            throw new XContentParseException(parser.getTokenLocation(), "expected START_OBJECT");
        }
        String key = null;
        NodeSelector result = NodeSelector.ANY;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                key = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                HasAttributeNodeSelector delegate = new HasAttributeNodeSelector(key, parser.text());
                NodeSelector newSelector = new NodeSelector((NodeSelector)delegate){
                    final /* synthetic */ NodeSelector val$delegate;
                    {
                        this.val$delegate = nodeSelector;
                    }

                    public void select(Iterable<Node> nodes) {
                        for (Node node : nodes) {
                            if (node.getAttributes() != null) continue;
                            throw new IllegalStateException("expected [attributes] metadata to be set but got " + node);
                        }
                        this.val$delegate.select(nodes);
                    }

                    public String toString() {
                        return this.val$delegate.toString();
                    }
                };
                result = result == NodeSelector.ANY ? newSelector : new ComposeNodeSelector(result, newSelector);
                continue;
            }
            throw new XContentParseException(parser.getTokenLocation(), "expected [" + key + "] to be a value");
        }
        return result;
    }

    private static NodeSelector parseVersionSelector(XContentParser parser) throws IOException {
        if (!parser.currentToken().isValue()) {
            throw new XContentParseException(parser.getTokenLocation(), "expected [version] to be a value");
        }
        final List<VersionRange> skipVersionRanges = SkipSection.parseVersionRanges(parser.text());
        return new NodeSelector(){

            public void select(Iterable<Node> nodes) {
                Iterator<Node> itr = nodes.iterator();
                while (itr.hasNext()) {
                    Node node = itr.next();
                    if (node.getVersion() == null) {
                        throw new IllegalStateException("expected [version] metadata to be set but got " + node);
                    }
                    Version version = Version.fromString((String)node.getVersion());
                    boolean skip = skipVersionRanges.stream().anyMatch(v -> v.contains(version));
                    if (skip) continue;
                    itr.remove();
                }
            }

            public String toString() {
                return "version ranges " + skipVersionRanges;
            }
        };
    }

    static {
        catches.put("bad_request", (Tuple<String, org.hamcrest.Matcher<Integer>>)Tuple.tuple((Object)"400", (Object)Matchers.equalTo((Object)400)));
        catches.put("unauthorized", (Tuple<String, org.hamcrest.Matcher<Integer>>)Tuple.tuple((Object)"401", (Object)Matchers.equalTo((Object)401)));
        catches.put("forbidden", (Tuple<String, org.hamcrest.Matcher<Integer>>)Tuple.tuple((Object)"403", (Object)Matchers.equalTo((Object)403)));
        catches.put("missing", (Tuple<String, org.hamcrest.Matcher<Integer>>)Tuple.tuple((Object)"404", (Object)Matchers.equalTo((Object)404)));
        catches.put("request_timeout", (Tuple<String, org.hamcrest.Matcher<Integer>>)Tuple.tuple((Object)"408", (Object)Matchers.equalTo((Object)408)));
        catches.put("conflict", (Tuple<String, org.hamcrest.Matcher<Integer>>)Tuple.tuple((Object)"409", (Object)Matchers.equalTo((Object)409)));
        catches.put("unavailable", (Tuple<String, org.hamcrest.Matcher<Integer>>)Tuple.tuple((Object)"503", (Object)Matchers.equalTo((Object)503)));
        catches.put("request", (Tuple<String, org.hamcrest.Matcher<Integer>>)Tuple.tuple((Object)"4xx|5xx", (Object)Matchers.allOf((org.hamcrest.Matcher[])new org.hamcrest.Matcher[]{Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(400)), Matchers.not((org.hamcrest.Matcher)Matchers.equalTo((Object)400)), Matchers.not((org.hamcrest.Matcher)Matchers.equalTo((Object)401)), Matchers.not((org.hamcrest.Matcher)Matchers.equalTo((Object)403)), Matchers.not((org.hamcrest.Matcher)Matchers.equalTo((Object)404)), Matchers.not((org.hamcrest.Matcher)Matchers.equalTo((Object)408)), Matchers.not((org.hamcrest.Matcher)Matchers.equalTo((Object)409))})));
    }

    private static class ComposeNodeSelector
    implements NodeSelector {
        private final NodeSelector lhs;
        private final NodeSelector rhs;

        private ComposeNodeSelector(NodeSelector lhs, NodeSelector rhs) {
            this.lhs = Objects.requireNonNull(lhs, "lhs is required");
            this.rhs = Objects.requireNonNull(rhs, "rhs is required");
        }

        public void select(Iterable<Node> nodes) {
            this.rhs.select(nodes);
            this.lhs.select(nodes);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComposeNodeSelector that = (ComposeNodeSelector)o;
            return Objects.equals(this.lhs, that.lhs) && Objects.equals(this.rhs, that.rhs);
        }

        public int hashCode() {
            return Objects.hash(this.lhs, this.rhs);
        }

        public String toString() {
            return this.lhs + "." + this.rhs;
        }
    }
}

