/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.upgrades;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.client.Request;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.test.rest.ESRestTestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;

public abstract class AbstractFullClusterRestartTestCase
extends ESRestTestCase {
    private final boolean runningAgainstOldCluster = Booleans.parseBoolean((String)System.getProperty("tests.is_old_cluster"));
    private final Version oldClusterVersion = Version.fromString((String)System.getProperty("tests.old_cluster_version"));

    @Before
    public void init() throws IOException {
        AbstractFullClusterRestartTestCase.assertThat((String)"we don't need this branch if we aren't compatible with 6.0", (Object)Version.CURRENT.minimumIndexCompatibilityVersion().onOrBefore(Version.V_6_0_0), (Matcher)Matchers.equalTo((Object)true));
        if (this.isRunningAgainstOldCluster() && this.getOldClusterVersion().before(Version.V_7_0_0)) {
            XContentBuilder template = XContentFactory.jsonBuilder();
            template.startObject();
            template.field("index_patterns", "*");
            template.field("order", "0");
            template.startObject("settings");
            template.field("number_of_shards", 5);
            template.endObject();
            template.endObject();
            Request createTemplate = new Request("PUT", "/_template/template");
            createTemplate.setJsonEntity(Strings.toString((XContentBuilder)template));
            AbstractFullClusterRestartTestCase.client().performRequest(createTemplate);
        }
    }

    public final boolean isRunningAgainstOldCluster() {
        return this.runningAgainstOldCluster;
    }

    protected final boolean isRunningAgainstAncientCluster() {
        return this.isRunningAgainstOldCluster() && this.oldClusterVersion.before(Version.V_7_0_0);
    }

    public final Version getOldClusterVersion() {
        return this.oldClusterVersion;
    }

    @Override
    protected boolean preserveIndicesUponCompletion() {
        return true;
    }

    @Override
    protected boolean preserveSnapshotsUponCompletion() {
        return true;
    }

    @Override
    protected boolean preserveReposUponCompletion() {
        return true;
    }

    @Override
    protected boolean preserveTemplatesUponCompletion() {
        return true;
    }

    @Override
    protected boolean preserveClusterSettings() {
        return true;
    }

    @Override
    protected boolean preserveRollupJobsUponCompletion() {
        return true;
    }

    @Override
    protected boolean preserveILMPoliciesUponCompletion() {
        return true;
    }

    @Override
    protected boolean preserveSLMPoliciesUponCompletion() {
        return true;
    }

    protected void assertNoFailures(Map<?, ?> response) {
        int failed = (Integer)XContentMapValues.extractValue((String)"_shards.failed", response);
        AbstractFullClusterRestartTestCase.assertEquals((long)0L, (long)failed);
    }

    protected void assertTotalHits(int expectedTotalHits, Map<?, ?> response) {
        int actualTotalHits = this.extractTotalHits(response);
        AbstractFullClusterRestartTestCase.assertEquals((String)response.toString(), (long)expectedTotalHits, (long)actualTotalHits);
    }

    protected int extractTotalHits(Map<?, ?> response) {
        if (this.isRunningAgainstOldCluster() && this.getOldClusterVersion().before(Version.V_7_0_0)) {
            return (Integer)XContentMapValues.extractValue((String)"hits.total", response);
        }
        return (Integer)XContentMapValues.extractValue((String)"hits.total.value", response);
    }
}

