/*
 * Decompiled with CFR 0.152.
 */
package org.exist.start;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.function.Supplier;
import org.exist.start.EXistClassLoader;

public class Classpath
implements Iterable<Path> {
    final List<Path> _elements = new ArrayList<Path>();

    public Classpath() {
    }

    public Classpath(String initial) {
        this.addClasspath(initial);
    }

    public boolean addComponent(String component) {
        if (component != null && component.length() > 0) {
            try {
                Path key;
                Path p = Paths.get(component, new String[0]);
                if (Files.exists(p, new LinkOption[0]) && !this._elements.contains(key = p.toAbsolutePath())) {
                    this._elements.add(key);
                    return true;
                }
            }
            catch (InvalidPathException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean addComponent(Path component) {
        if (component != null) {
            try {
                Path key;
                if (Files.exists(component, new LinkOption[0]) && !this._elements.contains(key = component.toAbsolutePath())) {
                    this._elements.add(key);
                    return true;
                }
            }
            catch (InvalidPathException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void addClasspath(String s) {
        if (s != null) {
            StringTokenizer t = new StringTokenizer(s, File.pathSeparator);
            while (t.hasMoreTokens()) {
                this.addComponent(t.nextToken());
            }
        }
    }

    public String toString() {
        StringBuilder cp = new StringBuilder(1024);
        int cnt = this._elements.size();
        if (cnt >= 1) {
            cp.append(this._elements.get(0));
        }
        for (int i = 1; i < cnt; ++i) {
            cp.append(File.pathSeparatorChar);
            cp.append(this._elements.get(i));
        }
        return cp.toString();
    }

    public EXistClassLoader getClassLoader(ClassLoader parent) {
        URL[] urls = (URL[])this._elements.stream().map(Path::toUri).map(u -> {
            try {
                return Optional.of(u.toURL());
            }
            catch (MalformedURLException e) {
                return Optional.empty();
            }
        }).filter(ou -> ou.isPresent()).map(Optional::get).toArray(URL[]::new);
        parent = Classpath.or(Classpath.or(Classpath.or(Optional.ofNullable(parent), () -> Optional.ofNullable(Thread.currentThread().getContextClassLoader())), () -> Optional.ofNullable(Classpath.class.getClassLoader())), () -> Optional.ofNullable(ClassLoader.getSystemClassLoader())).orElse(null);
        return new EXistClassLoader(urls, parent);
    }

    @Override
    public Iterator<Path> iterator() {
        return this._elements.iterator();
    }

    private static <T> Optional<T> or(Optional<T> left, Supplier<Optional<T>> right) {
        if (left.isPresent()) {
            return left;
        }
        return right.get();
    }
}

