/*
 * Decompiled with CFR 0.152.
 */
package org.exist.start;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exist.start.Main;

public class LatestFileResolver {
    private static final Pattern latestVersionPattern = Pattern.compile("(%latest%)");
    private static boolean _debug = Boolean.getBoolean("exist.start.debug");

    public String getResolvedFileName(String filename) {
        List<Path> jars;
        Matcher matches = latestVersionPattern.matcher(filename);
        if (!matches.find()) {
            return filename;
        }
        String[] fileinfo = filename.split("%latest%");
        String uptoToken = fileinfo[0];
        String containerDirName = uptoToken.substring(0, uptoToken.lastIndexOf(File.separatorChar));
        Path containerDir = Paths.get(containerDirName, new String[0]);
        String artifactId = Pattern.quote(uptoToken.substring(uptoToken.lastIndexOf(File.separatorChar) + 1));
        String suffix = Pattern.quote(fileinfo[1]);
        String patternString = '^' + artifactId + "(?:(?:[0-9]+(?:(?:\\.|_)[0-9]+)*)(?:-RC[0-9]+)?(?:-SNAPSHOT)?(?:-patched)?(?:-[0-9a-f]{7})?)" + suffix + '$';
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher("");
        try {
            jars = Main.list(containerDir, p -> {
                matcher.reset(Main.fileName(p));
                return matcher.find();
            });
        }
        catch (IOException e) {
            System.err.println("ERROR: No jars found in " + containerDir.toAbsolutePath());
            e.printStackTrace();
            jars = Collections.emptyList();
        }
        if (!jars.isEmpty()) {
            String actualFileName = jars.get(0).toAbsolutePath().toString();
            if (_debug) {
                System.err.println("Found match: " + actualFileName + " for jar file pattern: " + filename);
            }
            return actualFileName;
        }
        if (_debug) {
            System.err.println("WARN: No latest version found for JAR file: '" + filename + "'");
        }
        return filename;
    }
}

