/*
 * Decompiled with CFR 0.152.
 */
package org.exist.start;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.exist.start.Classpath;
import org.exist.start.EXistClassLoader;
import org.exist.start.StartException;
import org.exist.start.StopException;

public class Main {
    public static final String STANDARD_ENABLED_JETTY_CONFIGS = "standard.enabled-jetty-configs";
    public static final String STANDALONE_ENABLED_JETTY_CONFIGS = "standalone.enabled-jetty-configs";
    private static final int ERROR_CODE_GENERAL = 1;
    private static final int ERROR_CODE_NO_JETTY_CONFIG = 7;
    public static final String CONFIG_DIR_NAME = "etc";
    private static final String PROP_EXIST_START_DEBUG = "exist.start.debug";
    public static final String PROP_EXIST_JETTY_CONFIG = "exist.jetty.config";
    public static final String PROP_EXIST_HOME = "exist.home";
    public static final String PROP_JETTY_HOME = "jetty.home";
    private static final String PROP_LOG4J_CONFIGURATION_FILE = "log4j.configurationFile";
    private static final String PROP_JUL_MANAGER = "java.util.logging.manager";
    private static final String PROP_JAVA_TEMP_DIR = "java.io.tmpdir";
    public static final String ENV_EXIST_JETTY_CONFIG = "EXIST_JETTY_CONFIG";
    public static final String ENV_EXIST_HOME = "EXIST_HOME";
    public static final String ENV_JETTY_HOME = "JETTY_HOME";
    private static Main exist;
    private String _mode = "jetty";
    private boolean _debug = Boolean.getBoolean("exist.start.debug");

    public static void main(String[] args) {
        try {
            Main.getMain().run(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static Main getMain() {
        if (exist == null) {
            exist = new Main();
        }
        return exist;
    }

    public String getMode() {
        return this._mode;
    }

    private Main() {
    }

    public Main(String mode) {
        this._mode = mode;
    }

    private static Path getDirectory(String name) {
        try {
            Path dir;
            if (name != null && Files.isDirectory(dir = Paths.get(name, new String[0]).normalize().toAbsolutePath(), new LinkOption[0])) {
                return dir;
            }
        }
        catch (InvalidPathException invalidPathException) {
            // empty catch block
        }
        return null;
    }

    private static void invokeMain(ClassLoader classloader, String classname, String[] args) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        Class<?> invoked_class = classloader.loadClass(classname);
        Class[] method_param_types = new Class[]{args.getClass()};
        Method main = invoked_class.getDeclaredMethod("main", method_param_types);
        Object[] method_params = new Object[]{args};
        main.invoke(null, method_params);
    }

    public void run(String[] args) {
        try {
            this.runEx(args);
        }
        catch (StartException e) {
            System.exit(e.getErrorCode());
        }
    }

    public void runEx(String[] args) throws StartException {
        Optional<Path> log4jConfigurationFile;
        String _classname;
        if (args.length > 0) {
            if ("client".equals(args[0])) {
                _classname = "org.exist.client.InteractiveClient";
                this._mode = "client";
            } else if ("backup".equals(args[0])) {
                _classname = "org.exist.backup.Main";
                this._mode = "backup";
            } else if ("jetty".equals(args[0]) || "standalone".equals(args[0])) {
                _classname = "org.exist.jetty.JettyStart";
                this._mode = args[0];
            } else if ("launch".equals(args[0])) {
                _classname = "org.exist.launcher.LauncherWrapper";
                this._mode = "jetty";
            } else if ("shutdown".equals(args[0])) {
                _classname = "org.exist.jetty.ServerShutdown";
                this._mode = "other";
            } else {
                _classname = args[0];
                this._mode = "other";
            }
            String[] nargs = new String[args.length - 1];
            if (args.length > 1) {
                System.arraycopy(args, 1, nargs, 0, args.length - 1);
            }
            args = nargs;
        } else {
            _classname = "org.exist.launcher.LauncherWrapper";
            this._mode = "other";
        }
        if (this._debug) {
            System.err.println("mode=" + this._mode);
        }
        Optional<Path> existHomeDir = this.getFromSysPropOrEnv(PROP_EXIST_HOME, ENV_EXIST_HOME).map(x$0 -> Paths.get(x$0, new String[0]));
        if ("jetty".equals(this._mode) || "standalone".equals(this._mode)) {
            Optional<Path> jettyHomeDir = this.getFromSysPropOrEnv(PROP_JETTY_HOME, ENV_JETTY_HOME).map(x$0 -> Paths.get(x$0, new String[0]));
            Optional<Path> existJettyConfigFile = this.getFromSysPropOrEnv(PROP_EXIST_JETTY_CONFIG, ENV_EXIST_JETTY_CONFIG).map(x$0 -> Paths.get(x$0, new String[0]));
            if (!existJettyConfigFile.isPresent()) {
                String config = "jetty".equals(this._mode) ? STANDARD_ENABLED_JETTY_CONFIGS : STANDALONE_ENABLED_JETTY_CONFIGS;
                if (jettyHomeDir.isPresent() && Files.exists(jettyHomeDir.get().resolve(CONFIG_DIR_NAME), new LinkOption[0])) {
                    existJettyConfigFile = jettyHomeDir.map(f -> f.resolve(CONFIG_DIR_NAME).resolve(config));
                }
                if (existHomeDir.isPresent() && Files.exists(existHomeDir.get().resolve(CONFIG_DIR_NAME), new LinkOption[0])) {
                    existJettyConfigFile = existHomeDir.map(f -> f.resolve(CONFIG_DIR_NAME).resolve(config));
                }
                if (!existJettyConfigFile.isPresent()) {
                    System.err.println("ERROR: jetty config file could not be found! Make sure to set exist.jetty.config or EXIST_JETTY_CONFIG.");
                    System.err.flush();
                    throw new StartException(7);
                }
            }
            String[] jettyStartArgs = new String[1 + args.length];
            jettyStartArgs[0] = existJettyConfigFile.get().toAbsolutePath().toString();
            System.arraycopy(args, 0, jettyStartArgs, 1, args.length);
            args = jettyStartArgs;
        }
        if (!(log4jConfigurationFile = Optional.ofNullable(System.getProperty(PROP_LOG4J_CONFIGURATION_FILE)).map(x$0 -> Paths.get(x$0, new String[0]))).isPresent()) {
            if (existHomeDir.isPresent() && Files.exists(existHomeDir.get().resolve(CONFIG_DIR_NAME), new LinkOption[0])) {
                log4jConfigurationFile = existHomeDir.map(f -> f.resolve(CONFIG_DIR_NAME).resolve("log4j2.xml"));
            }
            if (log4jConfigurationFile.isPresent() && Files.isReadable(log4jConfigurationFile.get())) {
                System.setProperty(PROP_LOG4J_CONFIGURATION_FILE, log4jConfigurationFile.get().toAbsolutePath().toString());
            }
        }
        if (log4jConfigurationFile.isPresent()) {
            System.setProperty(PROP_JUL_MANAGER, Optional.ofNullable(System.getProperty(PROP_JUL_MANAGER)).orElse("org.apache.logging.log4j.jul.LogManager"));
        }
        try {
            Path tmpdir = Paths.get(System.getProperty(PROP_JAVA_TEMP_DIR), new String[0]).toAbsolutePath();
            if (Files.isDirectory(tmpdir, new LinkOption[0])) {
                System.setProperty(PROP_JAVA_TEMP_DIR, tmpdir.toString());
            }
        }
        catch (InvalidPathException tmpdir) {
            // empty catch block
        }
        if (this._debug) {
            System.err.println("java.io.tmpdir=" + System.getProperty(PROP_JAVA_TEMP_DIR));
        }
        Classpath _classpath = new Classpath();
        EXistClassLoader cl = _classpath.getClassLoader(null);
        Thread.currentThread().setContextClassLoader(cl);
        try {
            Main.invokeMain(cl, _classname, args);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new StartException(1);
        }
    }

    private Optional<String> getFromSysPropOrEnv(String sysPropName, String envVarName) {
        Optional<String> value = Optional.ofNullable(System.getProperty(sysPropName));
        if (!value.isPresent() && (value = Optional.ofNullable(System.getenv().get(envVarName))).isPresent()) {
            System.setProperty(sysPropName, value.get());
        }
        if (this._debug && value.isPresent()) {
            System.err.println(sysPropName + "=" + System.getProperty(sysPropName));
        }
        return value;
    }

    public void shutdown() {
        try {
            this.shutdownEx();
        }
        catch (StopException e) {
            e.printStackTrace();
        }
    }

    public void shutdownEx() throws StopException {
        try {
            Class<?> brokerPool = Class.forName("org.exist.storage.BrokerPools");
            Method stopAll = brokerPool.getDeclaredMethod("stopAll", Boolean.TYPE);
            stopAll.setAccessible(true);
            stopAll.invoke(null, false);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new StopException(e.getMessage(), e);
        }
    }

    static List<Path> list(Path directory, Predicate<Path> filter) throws IOException {
        try (Stream<Path> entries = Files.list(directory).filter(filter);){
            List<Path> list = entries.collect(Collectors.toList());
            return list;
        }
    }

    static String fileName(Path path) {
        return path.getFileName().toString();
    }
}

