/*
 * Decompiled with CFR 0.152.
 */
package org.exist.start;

public class Version {
    private static final int INFERIOR = -1;
    private static final int EQUAL = 0;
    private static final int SUPERIOR = 1;
    int _version = 0;
    int _revision = 0;
    int _subrevision = 0;
    String _suffix = "";

    public Version() {
    }

    public Version(String version_string) {
        this.parse(version_string);
    }

    public void parse(String version_string) {
        int pos;
        this._version = 0;
        this._revision = 0;
        this._subrevision = 0;
        this._suffix = "";
        int startpos = 0;
        int endpos = version_string.length();
        for (pos = 0; pos < endpos && Character.isDigit(version_string.charAt(pos)); ++pos) {
        }
        this._version = Integer.parseInt(version_string.substring(startpos, pos));
        if (pos < endpos && version_string.charAt(pos) == '.') {
            startpos = ++pos;
            while (pos < endpos && Character.isDigit(version_string.charAt(pos))) {
                ++pos;
            }
            this._revision = Integer.parseInt(version_string.substring(startpos, pos));
        }
        if (pos < endpos && version_string.charAt(pos) == '.') {
            startpos = ++pos;
            while (pos < endpos && Character.isDigit(version_string.charAt(pos))) {
                ++pos;
            }
            this._subrevision = Integer.parseInt(version_string.substring(startpos, pos));
        }
        if (pos < endpos) {
            this._suffix = version_string.substring(pos);
        }
    }

    public String toString() {
        return String.valueOf(this._version) + '.' + this._revision + '.' + this._subrevision + this._suffix;
    }

    public int compare(Version other) {
        if (other == null) {
            throw new NullPointerException("other version is null");
        }
        if (this._version < other._version) {
            return -1;
        }
        if (this._version > other._version) {
            return 1;
        }
        if (this._revision < other._revision) {
            return -1;
        }
        if (this._revision > other._revision) {
            return 1;
        }
        if (this._subrevision < other._subrevision) {
            return -1;
        }
        if (this._subrevision > other._subrevision) {
            return 1;
        }
        return 0;
    }

    public boolean isInRange(Version low, Version high) {
        return this.compare(low) >= 0 && this.compare(high) <= 0;
    }
}

