/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xpath.regex;

import java.util.HashMap;
import org.apache.xerces.impl.xpath.regex.REConstants;
import org.apache.xerces.impl.xpath.regex.REUtil;
import org.apache.xerces.impl.xpath.regex.RangeToken;
import org.apache.xerces.impl.xpath.regex.RangeTokenMap;
import org.apache.xerces.impl.xpath.regex.Token;

final class XML11TokenMap
implements RangeTokenMap {
    private HashMap ranges;
    private HashMap ranges2;

    private XML11TokenMap() {
        this.createRanges();
    }

    static RangeTokenMap instance() {
        return new XML11TokenMap();
    }

    private void createRanges() {
        this.ranges = new HashMap();
        this.ranges2 = new HashMap();
        RangeToken rangeToken = Token.createRange();
        REUtil.setupRange((Token)rangeToken, "\t\n\r\r  ");
        this.ranges.put("xml:isSpace", rangeToken);
        this.ranges2.put("xml:isSpace", Token.complementRanges(rangeToken));
        rangeToken = Token.createRange();
        REUtil.setupRange((Token)rangeToken, REConstants.DIGITS_INTS);
        this.ranges.put("xml:isDigit", rangeToken);
        this.ranges2.put("xml:isDigit", Token.complementRanges(rangeToken));
        rangeToken = Token.createRange();
        ((Token)rangeToken).mergeRanges(Token.getRange("P", true));
        ((Token)rangeToken).mergeRanges(Token.getRange("Z", true));
        ((Token)rangeToken).mergeRanges(Token.getRange("C", true));
        this.ranges2.put("xml:isWord", rangeToken);
        this.ranges.put("xml:isWord", Token.complementRanges(rangeToken));
        rangeToken = Token.createRange();
        REUtil.setupRange((Token)rangeToken, REConstants.NAMECHARS11_INTS);
        this.ranges.put("xml:isNameChar", rangeToken);
        this.ranges2.put("xml:isNameChar", Token.complementRanges(rangeToken));
        rangeToken = Token.createRange();
        REUtil.setupRange((Token)rangeToken, REConstants.NAMESTARTCHARS11_INTS);
        this.ranges.put("xml:isInitialNameChar", rangeToken);
        this.ranges2.put("xml:isInitialNameChar", Token.complementRanges(rangeToken));
    }

    public RangeToken get(String string, boolean bl) {
        return bl ? (RangeToken)this.ranges.get(string) : (RangeToken)this.ranges2.get(string);
    }
}

