/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime;

import org.faktorips.valueset.IntegerRange;

public class CardinalityRange
extends IntegerRange {
    public static final CardinalityRange OPTIONAL = new CardinalityRange(0, 1, 0);
    public static final CardinalityRange MANDATORY = new CardinalityRange(1, 1, 1);
    public static final CardinalityRange FULL_RANGE = new CardinalityRange(0, Integer.MAX_VALUE, 0);
    public static final CardinalityRange EXCLUDED = new CardinalityRange(){
        private static final long serialVersionUID = 1L;

        public Integer getLowerBound() {
            return 0;
        }

        public Integer getUpperBound() {
            return 0;
        }
    };
    private static final long serialVersionUID = -6655684714703290189L;
    private final Integer defaultCardinality;

    public CardinalityRange(Integer lower, Integer upper, Integer def) {
        super(lower, upper);
        this.defaultCardinality = def;
        if (lower > def || def > upper || def == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("The default cardinality is out of range. The default value must be in between the lower and upper bound or equal to one of them (though not Integer.MAX_VALUE).");
        }
    }

    private CardinalityRange() {
        this.defaultCardinality = 0;
    }

    public boolean isEmpty() {
        return super.isEmpty() || Integer.valueOf(0).equals(this.getUpperBound());
    }

    public Integer getDefaultCardinality() {
        return this.defaultCardinality;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof CardinalityRange) {
            boolean upperLowerAndStepEqual = super.equals(obj);
            return upperLowerAndStepEqual && this.getDefaultCardinality().equals(((CardinalityRange)((Object)obj)).getDefaultCardinality());
        }
        return false;
    }

    public int hashCode() {
        int upperLowerAndStepHashCode = super.hashCode();
        return upperLowerAndStepHashCode * 37 + this.getDefaultCardinality();
    }

    public String toString() {
        return this.getLowerBound() + ".." + this.getUpperBound() + ", default:" + this.getDefaultCardinality();
    }
}

