/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.faktorips.runtime.IMarker;
import org.faktorips.runtime.MsgReplacementParameter;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.Severity;
import org.faktorips.runtime.util.StringBuilderJoiner;

public class Message
implements Serializable {
    public static final Severity NONE = Severity.NONE;
    public static final Severity INFO = Severity.INFO;
    public static final Severity WARNING = Severity.WARNING;
    public static final Severity ERROR = Severity.ERROR;
    private static final long serialVersionUID = 6538319330010542283L;
    private final Severity severity;
    private final String text;
    private final String code;
    private final List<ObjectProperty> invalidOp;
    private final List<MsgReplacementParameter> replacementParameters;
    private final Set<? extends IMarker> markers;

    public Message(Builder builder) {
        this(builder.code, builder.text, builder.severity, builder.invalidObjectProperties, builder.replacementParams, builder.markers);
    }

    public Message(Message msg) {
        this(msg.code, msg.text, msg.severity, msg.invalidOp, msg.replacementParameters, msg.markers);
    }

    public Message(String text, Severity severity) {
        this(new Builder(text, severity));
    }

    public Message(String code, String text, Severity severity) {
        this(new Builder(text, severity).code(code));
    }

    public Message(String code, String text, Severity severity, Object invalidObject) {
        this(new Builder(text, severity).code(code).invalidObjectWithProperties(invalidObject, new String[]{null}));
    }

    public Message(String code, String text, Severity severity, ObjectProperty invalidObjectProperty) {
        this(new Builder(text, severity).code(code).invalidObjects(invalidObjectProperty));
    }

    public Message(String code, String text, Severity severity, Object invalidObject, String ... invalidObjectProperties) {
        this(new Builder(text, severity).code(code).invalidObjectWithProperties(invalidObject, invalidObjectProperties));
    }

    public Message(String code, String text, Severity severity, ObjectProperty ... invalidObjectProperties) {
        this(new Builder(text, severity).code(code).invalidObjects(List.of(invalidObjectProperties)));
    }

    public Message(String code, String text, Severity severity, List<ObjectProperty> invalidObjectProperties) {
        this(new Builder(text, severity).code(code).invalidObjects(invalidObjectProperties));
    }

    public Message(String code, String text, Severity severity, List<ObjectProperty> invalidObjectProperties, List<MsgReplacementParameter> replacementParameters) {
        this(new Builder(text, severity).code(code).invalidObjects(invalidObjectProperties).replacements(replacementParameters).markers(Collections.emptySet()));
    }

    public Message(String code, String text, Severity severity, ObjectProperty invalidObjectProperty, MsgReplacementParameter ... parameters) {
        this(new Builder(text, severity).code(code).invalidObjects(invalidObjectProperty).replacements(parameters).markers(Collections.emptySet()));
    }

    public Message(String code, String text, Severity severity, ObjectProperty invalidObjectProperty, List<MsgReplacementParameter> parameters) {
        this(new Builder(text, severity).code(code).invalidObjects(invalidObjectProperty).replacements(parameters).markers(Collections.emptySet()));
    }

    public Message(String code, String text, Severity severity, ObjectProperty[] invalidObjectProperties, MsgReplacementParameter[] parameters) {
        this(new Builder(text, severity).code(code).invalidObjects(List.of(invalidObjectProperties)).replacements(parameters).markers(Collections.emptySet()));
    }

    public Message(String code, String text, Severity severity, List<ObjectProperty> invalidObjectProperties, List<MsgReplacementParameter> parameters, Set<? extends IMarker> markers) {
        this.code = code;
        this.text = text;
        this.severity = severity;
        this.markers = markers != null ? Collections.unmodifiableSet(new LinkedHashSet<IMarker>(markers)) : Set.of();
        this.invalidOp = invalidObjectProperties != null ? List.copyOf(invalidObjectProperties) : List.of();
        this.replacementParameters = parameters != null ? List.copyOf(parameters) : List.of();
    }

    public static final Builder error(String text) {
        return new Builder(text, ERROR);
    }

    public static final Builder warning(String text) {
        return new Builder(text, WARNING);
    }

    public static final Builder info(String text) {
        return new Builder(text, INFO);
    }

    public static final Message createCopy(Message msg, Object oldObject, Object newObject) {
        List<ObjectProperty> op = msg.getInvalidObjectProperties();
        ArrayList<ObjectProperty> newOp = new ArrayList<ObjectProperty>(op.size());
        for (ObjectProperty objectProperty : op) {
            if (objectProperty.getObject() == oldObject) {
                newOp.add(new ObjectProperty(newObject, objectProperty.getProperty()));
                continue;
            }
            newOp.add(objectProperty);
        }
        return new Builder(msg.text, msg.severity).code(msg.code).invalidObjects(newOp).replacements(msg.getReplacementParameters()).markers(msg.getMarkers()).create();
    }

    public static final Message createCopy(Message msg, Map<ObjectProperty, ObjectProperty> objectPropertyMap) {
        List<ObjectProperty> op = msg.getInvalidObjectProperties();
        ArrayList<ObjectProperty> newOp = new ArrayList<ObjectProperty>(op.size());
        for (ObjectProperty objectProperty : op) {
            ObjectProperty newObjectProperty = objectPropertyMap.get(objectProperty);
            if (newObjectProperty != null) {
                newOp.add(newObjectProperty);
                continue;
            }
            newOp.add(objectProperty);
        }
        return new Builder(msg.text, msg.severity).code(msg.code).invalidObjects(newOp).replacements(msg.getReplacementParameters()).markers(msg.getMarkers()).create();
    }

    public static final Message newInfo(String code, String text) {
        return new Message(code, text, INFO);
    }

    public static final Message newInfo(String code, String text, Object invalidObject, String invalidProperty) {
        return new Message(code, text, INFO, invalidObject, invalidProperty);
    }

    public static final Message newWarning(String code, String text) {
        return new Message(code, text, WARNING);
    }

    public static final Message newWarning(String code, String text, Object invalidObject) {
        return new Message(code, text, WARNING, new ObjectProperty[]{new ObjectProperty(invalidObject, null)});
    }

    public static final Message newWarning(String code, String text, Object invalidObject, String ... invalidProperties) {
        return new Message(code, text, WARNING, invalidObject, invalidProperties);
    }

    public static final Message newError(String code, String text) {
        return new Message(code, text, ERROR);
    }

    public static final Message newError(String code, String text, Object invalidObject, String ... invalidProperties) {
        return new Message(code, text, ERROR, invalidObject, invalidProperties);
    }

    public static final Message newError(String code, String text, ObjectProperty ... invalidObjectProperty) {
        return new Message(code, text, ERROR, invalidObjectProperty);
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getText() {
        return this.text;
    }

    public String getCode() {
        return this.code;
    }

    public int getNumOfInvalidObjectProperties() {
        if (this.invalidOp == null) {
            return 0;
        }
        return this.invalidOp.size();
    }

    public List<ObjectProperty> getInvalidObjectProperties() {
        if (this.invalidOp == null) {
            return List.of();
        }
        return Collections.unmodifiableList(this.invalidOp);
    }

    public int getNumOfReplacementParameters() {
        if (this.replacementParameters == null) {
            return 0;
        }
        return this.replacementParameters.size();
    }

    public List<MsgReplacementParameter> getReplacementParameters() {
        if (this.replacementParameters == null) {
            return List.of();
        }
        return this.replacementParameters;
    }

    public boolean hasReplacementParameter(String paramName) {
        if (this.replacementParameters == null) {
            return false;
        }
        for (MsgReplacementParameter replacementParameter : this.replacementParameters) {
            if (!replacementParameter.getName().equals(paramName)) continue;
            return true;
        }
        return false;
    }

    public Object getReplacementValue(String paramName) {
        if (this.replacementParameters == null) {
            return null;
        }
        for (MsgReplacementParameter replacementParameter : this.replacementParameters) {
            if (!replacementParameter.getName().equals(paramName)) continue;
            return replacementParameter.getValue();
        }
        return null;
    }

    public Set<? extends IMarker> getMarkers() {
        return this.markers;
    }

    public boolean hasMarker(IMarker marker) {
        return this.markers.contains(marker);
    }

    public boolean hasMarkers() {
        return !this.markers.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this.severity) {
            case ERROR: {
                sb.append("ERROR");
                break;
            }
            case WARNING: {
                sb.append("WARNING ");
                break;
            }
            case INFO: {
                sb.append("INFO");
                break;
            }
            default: {
                sb.append("Severity ");
                sb.append((Object)this.severity);
            }
        }
        sb.append(' ');
        sb.append(this.code);
        this.appendInvalidObjectProperties(sb);
        sb.append(System.lineSeparator());
        sb.append(this.text);
        return sb.toString();
    }

    public void appendInvalidObjectProperties(StringBuilder sb) {
        sb.append('[');
        StringBuilderJoiner.join(sb, this.invalidOp, op -> {
            sb.append(op.getObject().toString());
            sb.append('.');
            sb.append(op.getProperty());
        });
        sb.append(']');
    }

    public boolean equals(Object o) {
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!(Objects.equals(this.code, other.code) && Objects.equals(this.text, other.text) && this.severity == other.severity && Objects.equals(this.invalidOp, other.invalidOp))) {
            return false;
        }
        return Objects.equals(this.replacementParameters, other.replacementParameters) && Objects.equals(this.markers, other.markers);
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    public static class Builder {
        private String text;
        private Severity severity;
        private String code;
        private final List<ObjectProperty> invalidObjectProperties = new ArrayList<ObjectProperty>();
        private final List<MsgReplacementParameter> replacementParams = new ArrayList<MsgReplacementParameter>();
        private final Set<IMarker> markers = new LinkedHashSet<IMarker>();

        public Builder(String text, Severity severity) {
            this.text = text;
            this.severity = severity;
        }

        public Builder(Message message) {
            this(message.text, message.severity);
            this.code = message.code;
            this.invalidObjectProperties.addAll(message.getInvalidObjectProperties());
            this.replacementParams.addAll(message.getReplacementParameters());
            this.markers.addAll(message.getMarkers());
        }

        public Builder code(String code) {
            this.code = code;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder severity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public Builder invalidObjects(List<ObjectProperty> invalidObjectProperties) {
            this.invalidObjectProperties.addAll(invalidObjectProperties);
            return this;
        }

        public Builder invalidObject(ObjectProperty invalidObjectProperty) {
            return this.invalidObjects(invalidObjectProperty);
        }

        public Builder invalidObjects(ObjectProperty ... invalidObjectProperties) {
            return this.invalidObjects(List.of(invalidObjectProperties));
        }

        public Builder invalidObjectWithProperties(Object object, String ... properties) {
            if (properties.length == 0) {
                this.invalidObjectProperties.add(new ObjectProperty(object));
            } else {
                for (String property : properties) {
                    this.invalidObjectProperties.add(new ObjectProperty(object, property));
                }
            }
            return this;
        }

        public Builder replacements(List<MsgReplacementParameter> replacementParams) {
            this.replacementParams.addAll(replacementParams);
            return this;
        }

        public Builder replacements(MsgReplacementParameter ... replacementParams) {
            this.replacementParams.addAll(List.of(replacementParams));
            return this;
        }

        public Builder replacements(String name, Object value) {
            this.replacementParams.add(new MsgReplacementParameter(name, value));
            return this;
        }

        public Builder markers(Collection<? extends IMarker> markers) {
            this.markers.addAll(markers);
            return this;
        }

        public Builder markers(IMarker ... markers) {
            this.markers.addAll(List.of(markers));
            return this;
        }

        public Message create() {
            return new Message(this);
        }
    }
}

