/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.beans.Expression;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.faktorips.runtime.ICacheFactory;
import org.faktorips.runtime.IClRepositoryObject;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.ITable;
import org.faktorips.runtime.internal.AbstractTocBasedRuntimeRepository;
import org.faktorips.runtime.internal.DateTime;
import org.faktorips.runtime.internal.EnumContent;
import org.faktorips.runtime.internal.EnumSaxHandler;
import org.faktorips.runtime.internal.IpsEnum;
import org.faktorips.runtime.internal.ProductComponent;
import org.faktorips.runtime.internal.ProductComponentGeneration;
import org.faktorips.runtime.internal.Table;
import org.faktorips.runtime.internal.XmlUtil;
import org.faktorips.runtime.internal.productvariant.ProductVariantRuntimeHelper;
import org.faktorips.runtime.internal.toc.CustomTocEntryObject;
import org.faktorips.runtime.internal.toc.EnumContentTocEntry;
import org.faktorips.runtime.internal.toc.GenerationTocEntry;
import org.faktorips.runtime.internal.toc.ProductCmptTocEntry;
import org.faktorips.runtime.internal.toc.TableContentTocEntry;
import org.faktorips.runtime.internal.toc.TestCaseTocEntry;
import org.faktorips.runtime.internal.toc.TocEntry;
import org.faktorips.runtime.test.IpsTestCase2;
import org.faktorips.runtime.test.IpsTestCaseBase;
import org.faktorips.values.InternationalString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractXmlInputStreamRepository
extends AbstractTocBasedRuntimeRepository {
    private final ProductVariantRuntimeHelper productVariantHelper = new ProductVariantRuntimeHelper();

    public AbstractXmlInputStreamRepository(String name, ICacheFactory cacheFactory, ClassLoader cl) {
        super(name, cacheFactory, cl);
    }

    protected abstract InputStream getXmlAsStream(EnumContentTocEntry var1);

    protected abstract InputStream getXmlAsStream(TableContentTocEntry var1);

    protected abstract InputStream getXmlAsStream(TocEntry var1);

    protected ProductVariantRuntimeHelper getProductVariantHelper() {
        return this.productVariantHelper;
    }

    @Override
    protected <T> IpsEnum<T> createEnumValues(EnumContentTocEntry tocEntry, Class<T> enumClass) {
        EnumContent enumContent = this.getEnumContentFromSaxHandler(tocEntry);
        if (enumContent == null) {
            return null;
        }
        if (enumContent.getEnumValues().isEmpty()) {
            return new IpsEnum(new ArrayList(), enumContent.getDescription());
        }
        Constructor<T> constructor = this.getCandidateConstructorThrowRuntimeException(tocEntry, enumClass, this.getParameterSize(enumContent.getEnumValues()));
        return this.getCreatedEnumValueList(tocEntry, enumContent, constructor, this.getEnumValuesDefinedInType(enumClass).size());
    }

    @Override
    protected IProductComponent createProductCmpt(ProductCmptTocEntry tocEntry) {
        ProductComponent productCmpt;
        Element prodCmptElement = this.getDocumentElement(tocEntry);
        if (!this.getProductVariantHelper().isProductVariantXML(prodCmptElement)) {
            productCmpt = this.createProductComponentInstance(tocEntry.getImplementationClassName(), tocEntry.getIpsObjectId(), tocEntry.getKindId(), tocEntry.getVersionId());
            productCmpt.initFromXml(prodCmptElement);
        } else {
            ProductComponent originalProdCmpt = this.getProductVariantHelper().getOriginalProdCmpt(this, prodCmptElement);
            productCmpt = this.createProductComponentInstance(originalProdCmpt.getClass().getName(), tocEntry.getIpsObjectId(), tocEntry.getKindId(), tocEntry.getVersionId());
            this.getProductVariantHelper().initProductComponentVariation(originalProdCmpt, productCmpt, prodCmptElement);
        }
        productCmpt.setQualifiedName(tocEntry.getIpsObjectQualifiedName());
        return productCmpt;
    }

    @Override
    protected IProductComponentGeneration createProductCmptGeneration(GenerationTocEntry generationTocEntry) {
        Element genElement = this.getDocumentElement(generationTocEntry);
        if (!this.getProductVariantHelper().isProductVariantXML(genElement)) {
            ProductComponent productCmpt = (ProductComponent)this.getProductComponent(generationTocEntry.getParent().getIpsObjectId());
            if (productCmpt == null) {
                throw new RuntimeException("Can't get product component for toc entry " + generationTocEntry);
            }
            ProductComponentGeneration productCmptGen = this.createProductComponentGenerationInstance(generationTocEntry, productCmpt);
            productCmptGen.initFromXml(genElement);
            return productCmptGen;
        }
        return this.getProductVariantHelper().initProductComponentGenerationVariation(this, generationTocEntry, genElement);
    }

    @Override
    protected ITable<?> createTable(TableContentTocEntry tocEntry) {
        Table table;
        Class<?> implClass = this.getClass(tocEntry.getImplementationClassName(), this.getClassLoader());
        try {
            Constructor<?> constructor = this.getTableConstructor(implClass, tocEntry);
            table = (Table)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw this.createCannotInstantiateException(e, tocEntry);
        }
        try (InputStream is = this.getXmlAsStream(tocEntry);){
            table.initFromXml(is, this, tocEntry.getIpsObjectId());
        }
        catch (Exception e) {
            throw new RuntimeException("Can't parse xml for " + tocEntry.getIpsObjectId(), e);
        }
        return table;
    }

    @Override
    protected IpsTestCaseBase createTestCase(TestCaseTocEntry tocEntry, IRuntimeRepository runtimeRepository) {
        IpsTestCaseBase test;
        try {
            Constructor<?> constructor = this.getTestCaseConstructor(tocEntry);
            test = (IpsTestCaseBase)constructor.newInstance(tocEntry.getIpsObjectQualifiedName());
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw this.createCannotInstantiateException(e, tocEntry);
        }
        test.setRepository(runtimeRepository);
        if (test instanceof IpsTestCase2) {
            Element docElement = this.getDocumentElement(tocEntry);
            ((IpsTestCase2)test).initFromXml(docElement);
        }
        test.setFullPath(tocEntry.getIpsObjectId());
        return test;
    }

    @Override
    protected <T> T createCustomObject(CustomTocEntryObject<T> tocEntry) {
        T runtimeObject = tocEntry.createRuntimeObject(this);
        if (runtimeObject instanceof IClRepositoryObject) {
            this.initRepositoryObject(tocEntry, (IClRepositoryObject)runtimeObject);
        }
        return runtimeObject;
    }

    protected Element getDocumentElement(GenerationTocEntry tocEntry) {
        Element docElement = this.getDocumentElement(tocEntry.getParent());
        NodeList nl = docElement.getChildNodes();
        DateTime validFrom = tocEntry.getValidFrom();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element genElement;
            DateTime generationValidFrom;
            if (!"Generation".equals(nl.item(i).getNodeName()) || !validFrom.equals(generationValidFrom = DateTime.parseIso((genElement = (Element)nl.item(i)).getAttribute("validFrom")))) continue;
            return genElement;
        }
        throw new RuntimeException("Can't find the generation for the ToC entry " + tocEntry);
    }

    protected Element getDocumentElement(ProductCmptTocEntry tocEntry) {
        return this.getDocumentElementInternal(tocEntry);
    }

    protected Element getDocumentElement(TestCaseTocEntry tocEntry) {
        return this.getDocumentElementInternal(tocEntry);
    }

    protected <T> Element getDocumentElement(CustomTocEntryObject<T> tocEntry) {
        return this.getDocumentElementInternal(tocEntry);
    }

    protected ProductComponentGeneration createProductComponentGenerationInstance(GenerationTocEntry tocEntry, ProductComponent productCmpt) {
        ProductComponentGeneration productCmptGen;
        try {
            Class<?> implClass = this.getClass(tocEntry.getImplementationClassName(), this.getClassLoader());
            Expression expression = new Expression(implClass, "new", new Object[]{productCmpt});
            productCmptGen = (ProductComponentGeneration)expression.getValue();
        }
        catch (Exception e) {
            throw this.createCannotInstantiateException(e, tocEntry);
        }
        return productCmptGen;
    }

    protected ProductComponent createProductComponentInstance(String implementationClassName, String ipsObjectId, String kindId, String versionId) {
        ProductComponent productCmpt;
        try {
            Constructor<?> constructor = this.getProductComponentConstructor(implementationClassName);
            productCmpt = (ProductComponent)constructor.newInstance(this, ipsObjectId, kindId, versionId);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Can't create product component instance for class name \"" + implementationClassName + "\". RuntimeId=" + ipsObjectId, e);
        }
        return productCmpt;
    }

    private Constructor<?> getTableConstructor(Class<?> implClass, TableContentTocEntry tocEntry) {
        try {
            return implClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw this.createCannotInstantiateException(e, tocEntry);
        }
    }

    private <T> void initRepositoryObject(CustomTocEntryObject<T> tocEntry, IClRepositoryObject runtimeObject) {
        Element docElement = this.getDocumentElement(tocEntry);
        runtimeObject.initFromXml(docElement);
    }

    private EnumContent getEnumContentFromSaxHandler(EnumContentTocEntry tocEntry) {
        InputStream xmlAsStream = this.getXmlAsStream(tocEntry);
        if (AbstractXmlInputStreamRepository.isAvailable(xmlAsStream)) {
            return AbstractXmlInputStreamRepository.parseEnumValues(tocEntry, xmlAsStream);
        }
        return null;
    }

    private static EnumContent parseEnumValues(EnumContentTocEntry tocEntry, InputStream xmlAsStream) {
        EnumSaxHandler saxhandler = new EnumSaxHandler();
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse(new InputSource(xmlAsStream), (DefaultHandler)saxhandler);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            AbstractXmlInputStreamRepository.throwCantParseEnumContentException(tocEntry, e);
        }
        return saxhandler.getEnumContent();
    }

    private static void throwCantParseEnumContentException(EnumContentTocEntry tocEntry, Exception e) {
        throw new RuntimeException("Can't parse the enumeration content of the resource " + tocEntry.getXmlResourceName(), e);
    }

    private static boolean isAvailable(InputStream inputStream) {
        try {
            return inputStream != null && inputStream.available() > 0;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private int getParameterSize(List<List<Object>> enumValueList) {
        return enumValueList.get(0).size() + 2;
    }

    private <T> Constructor<T> getCandidateConstructorThrowRuntimeException(EnumContentTocEntry tocEntry, Class<T> enumClass, int parameterSize) {
        Class<?> runtimeRepoClass = this.getClass(IRuntimeRepository.class.getName(), this.getClassLoader());
        Constructor<T> constructor = this.getCorrectConstructor(parameterSize, runtimeRepoClass, enumClass);
        if (constructor == null) {
            throw new RuntimeException("No valid constructor found to create enumerations instances for the toc entry " + tocEntry);
        }
        return constructor;
    }

    private <T> IpsEnum<T> getCreatedEnumValueList(EnumContentTocEntry tocEntry, EnumContent enumContent, Constructor<T> constructor, int startIndex) {
        Object enumValue = null;
        ArrayList<Object> enumValues = new ArrayList<Object>();
        int valueCounterForIndexParameter = startIndex;
        for (List<Object> enumValueAsStrings : enumContent.getEnumValues()) {
            constructor.setAccessible(true);
            Object[] enumAttributeValues = enumValueAsStrings.toArray();
            Object[] parameters = new Object[enumAttributeValues.length + 2];
            this.setValuesForParamters(valueCounterForIndexParameter, enumAttributeValues, parameters);
            enumValue = this.createEnumValue(constructor, parameters, tocEntry);
            enumValues.add(enumValue);
            ++valueCounterForIndexParameter;
        }
        return new IpsEnum(enumValues, enumContent.getDescription());
    }

    private Constructor<?> getTestCaseConstructor(TestCaseTocEntry tocEntry) {
        try {
            Class<?> implClass = this.getClass(tocEntry.getImplementationClassName(), this.getClassLoader());
            return implClass.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            throw this.createCannotInstantiateException(e, tocEntry);
        }
    }

    private RuntimeException createCannotInstantiateException(Exception e, TocEntry tocEntry) {
        return new RuntimeException("Can't create instance for toc entry " + tocEntry, e);
    }

    private <T> Constructor<T> getCorrectConstructor(int parameterSize, Class<?> runtimeRepoClass, Class<T> enumClass) {
        Constructor<?>[] constructors = enumClass.getDeclaredConstructors();
        Constructor<?> constructor = null;
        for (Constructor<?> currentConstructor : constructors) {
            Constructor<?> castedConstructor;
            Class<?>[] parameterTypes;
            if (!this.isProtected(currentConstructor) || (parameterTypes = currentConstructor.getParameterTypes()).length != parameterSize) continue;
            boolean correct = true;
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> parameterClass = parameterTypes[i];
                if (i == parameterTypes.length - 1) {
                    if (parameterClass == runtimeRepoClass) continue;
                    correct = false;
                    break;
                }
                if (!this.isParameterClassValid(parameterClass)) continue;
                correct = false;
                break;
            }
            if (!correct) continue;
            constructor = castedConstructor = currentConstructor;
            break;
        }
        return constructor;
    }

    private boolean isProtected(Constructor<?> currentConstructor) {
        return (currentConstructor.getModifiers() & 4) > 0;
    }

    private boolean isParameterClassValid(Class<?> parameterClass) {
        return parameterClass != String.class && !InternationalString.class.isAssignableFrom(parameterClass) && parameterClass != Integer.TYPE;
    }

    private void setValuesForParamters(int valueCounterForIndexParameter, Object[] enumAttributeValues, Object[] parameters) {
        parameters[0] = valueCounterForIndexParameter;
        System.arraycopy(enumAttributeValues, 0, parameters, 1, enumAttributeValues.length);
        parameters[enumAttributeValues.length + 1] = this;
    }

    private <T> T createEnumValue(Constructor<T> constructor, Object[] parameters, TocEntry tocEntry) {
        T enumValue;
        try {
            enumValue = constructor.newInstance(parameters);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw this.createCannotInstantiateException(e, tocEntry);
        }
        return enumValue;
    }

    private Constructor<?> getProductComponentConstructor(String implementationClassName) {
        try {
            Class<?> implClass = this.getClass(implementationClassName, this.getClassLoader());
            Class<?> runtimeRepoClass = this.getClass(IRuntimeRepository.class.getName(), this.getClassLoader());
            return implClass.getConstructor(runtimeRepoClass, String.class, String.class, String.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Can't create product component instance for class name \"" + implementationClassName);
        }
    }

    private Element getDocumentElementInternal(TocEntry tocEntry) {
        Document doc;
        String resource = tocEntry.getXmlResourceName();
        try (InputStream is = this.getXmlAsStream(tocEntry);){
            DocumentBuilder documentBuilder = XmlUtil.getDocumentBuilder();
            doc = documentBuilder.parse(new InputSource(new InputStreamReader(is, StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            throw new RuntimeException("Can't parse xml resource " + resource, e);
        }
        Element element = doc.getDocumentElement();
        if (element == null) {
            throw new RuntimeException("Xml resource " + resource + " hasn't got a document element.");
        }
        return element;
    }
}

