/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.internal.CsvTableReader;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.internal.Table;
import org.faktorips.values.DefaultInternationalString;
import org.faktorips.values.LocalizedString;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TableSaxHandler
extends DefaultHandler {
    private static final String CSV_FORMAT = "CSV";
    private static final String VALUE = "Value";
    private static final String ROW = "Row";
    private static final String ROWS = "Rows";
    private static final String PROPERTY_FORMAT = "format";
    private final List<LocalizedString> descriptions = new ArrayList<LocalizedString>();
    private Table<?> table;
    private List<String> columns = new ArrayList<String>(20);
    private StringBuilder textBuilder = null;
    private boolean insideRowNode;
    private boolean insideCsvContent;
    private boolean insideValueNode;
    private boolean nullValue;
    private boolean insideDescriptionNode;
    private String currentDescriptionLocale;
    private IRuntimeRepository productRepository;

    public TableSaxHandler(Table<?> table, IRuntimeRepository productRepository) {
        this.table = table;
        this.productRepository = productRepository;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (ROWS.equals(qName) && this.insideCsvContent) {
            this.insideCsvContent = false;
            this.initFromCsv(this.getText());
        } else if (ROW.equals(qName)) {
            this.insideRowNode = false;
            this.table.addRow(this.columns, this.productRepository);
            this.columns.clear();
        } else if (this.isColumnValueNode(qName)) {
            this.insideValueNode = false;
            this.columns.add(this.getText());
            this.textBuilder = null;
        } else if ("Description".equals(qName)) {
            this.insideDescriptionNode = false;
            this.handleDescription();
        }
    }

    private void handleDescription() {
        if (!IpsStringUtils.isEmpty(this.currentDescriptionLocale)) {
            Locale locale = new Locale(this.currentDescriptionLocale);
            this.descriptions.add(new LocalizedString(locale, this.getText()));
        }
        this.textBuilder = null;
    }

    private String getText() {
        if (this.textBuilder != null) {
            return this.textBuilder.toString();
        }
        return this.nullValue ? null : "";
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (ROWS.equals(qName)) {
            this.insideCsvContent = this.isFormatCsv(attributes);
        } else if (ROW.equals(qName)) {
            this.insideRowNode = true;
        } else if (this.isColumnValueNode(qName)) {
            this.insideValueNode = true;
            this.nullValue = Boolean.parseBoolean(attributes.getValue("isNull"));
        } else if ("Description".equals(qName)) {
            this.insideDescriptionNode = true;
            this.currentDescriptionLocale = attributes.getValue("locale");
        }
    }

    private boolean isFormatCsv(Attributes attributes) {
        String format = attributes.getValue(PROPERTY_FORMAT);
        return CSV_FORMAT.equals(format);
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        if (!(this.insideValueNode || this.insideCsvContent || this.insideDescriptionNode)) {
            return;
        }
        String s = new String(buf, offset, len);
        if (this.textBuilder == null) {
            this.textBuilder = new StringBuilder(s);
        } else {
            this.textBuilder.append(s);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        Locale locale = this.descriptions.isEmpty() ? Locale.getDefault() : this.descriptions.get(0).getLocale();
        this.table.description = new DefaultInternationalString(this.descriptions, locale);
    }

    private boolean isColumnValueNode(String nodeName) {
        return VALUE.equals(nodeName) && this.insideRowNode;
    }

    private void initFromCsv(String csv) {
        try (StringReader stringReader = new StringReader(csv);){
            try {
                this.getClass().getClassLoader().loadClass("com.opencsv.CSVReader");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Failed to load OpenCSV", e);
            }
            CsvTableReader.readCsv(stringReader, this.table, this.productRepository);
        }
    }
}

