/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal.toc;

import java.util.Objects;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class TocEntry {
    public static final String PROPERTY_XML_RESOURCE = "xmlResource";
    public static final String PROPERTY_IMPLEMENTATION_CLASS = "implementationClass";
    private String xmlResourceName = "";
    private String implementationClassName = "";

    public TocEntry(String implementationClassName, String xmlResource) {
        this.implementationClassName = implementationClassName;
        this.xmlResourceName = xmlResource;
    }

    public String getXmlResourceName() {
        return this.xmlResourceName;
    }

    public String getImplementationClassName() {
        return this.implementationClassName;
    }

    protected void addToXml(Element element) {
        if (this.xmlResourceName != null && !this.xmlResourceName.isEmpty()) {
            element.setAttribute(PROPERTY_XML_RESOURCE, this.xmlResourceName);
        }
        element.setAttribute(PROPERTY_IMPLEMENTATION_CLASS, this.implementationClassName);
    }

    public final Element toXml(Document doc) {
        Element entryElement = doc.createElement(this.getXmlElementTag());
        this.addToXml(entryElement);
        return entryElement;
    }

    protected abstract String getXmlElementTag();

    public int hashCode() {
        return Objects.hash(this.implementationClassName, this.xmlResourceName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof TocEntry)) {
            return false;
        }
        TocEntry other = (TocEntry)obj;
        return Objects.equals(this.implementationClassName, other.implementationClassName) && Objects.equals(this.xmlResourceName, other.xmlResourceName);
    }
}

