/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type;

import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.model.enumtype.EnumAttribute;
import org.faktorips.runtime.model.type.DocumentationKind;
import org.faktorips.runtime.model.type.ModelElement;
import org.faktorips.runtime.model.type.TypePart;
import org.faktorips.runtime.util.MessagesHelper;

public class Documentation {
    public static final String INHERIT_DESCRIPTION_TAG = "{inheritDesc}";

    private Documentation() {
    }

    public static <E extends ModelElement> String of(E element, DocumentationKind type, Locale locale, String fallback, Supplier<Optional<? extends E>> superElementGetter) {
        String documentation = fallback;
        MessagesHelper messageHelper = element.getMessageHelper();
        if (messageHelper != null) {
            Optional<E> superElement;
            String docFallback = element instanceof TypePart || element instanceof EnumAttribute ? "" : fallback;
            documentation = messageHelper.getMessageOr(element.getMessageKey(type), locale, docFallback);
            if (IpsStringUtils.isEmpty(documentation)) {
                Optional<E> superElement2 = superElementGetter.get();
                if (superElement2.isPresent()) {
                    documentation = ((ModelElement)superElement2.get()).getDocumentation(locale, type, docFallback);
                }
            } else if (documentation.contains(INHERIT_DESCRIPTION_TAG) && (superElement = superElementGetter.get()).isPresent()) {
                documentation = documentation.replace(INHERIT_DESCRIPTION_TAG, ((ModelElement)superElement.get()).getDocumentation(locale, type, fallback));
            }
            if (IpsStringUtils.isEmpty(documentation)) {
                documentation = fallback;
            }
        }
        return documentation;
    }
}

