/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Optional;
import org.faktorips.runtime.model.annotation.IpsAllowedValues;
import org.faktorips.runtime.model.annotation.IpsDefaultValue;
import org.faktorips.runtime.model.type.ModelElement;
import org.faktorips.runtime.model.type.ProductCmptType;
import org.faktorips.runtime.model.type.Type;
import org.faktorips.valueset.ValueSet;

class FieldFinder<ANNOTATION extends Annotation, T> {
    private final Type type;
    private final Class<ANNOTATION> annotationClass;
    private final Type.AnnotatedElementMatcher<ANNOTATION> matcher;
    private Optional<Field> field;
    private boolean changingOverTime;

    private FieldFinder(Type type, Class<ANNOTATION> annotationClass, Type.AnnotatedElementMatcher<ANNOTATION> matcher, boolean changingOverTime) {
        this.type = type;
        this.annotationClass = annotationClass;
        this.matcher = matcher;
        this.changingOverTime = changingOverTime;
    }

    public Optional<T> get() {
        return this.getField().map(field -> ModelElement.invokeField(field, null));
    }

    private Optional<Field> getField() {
        if (this.field != null) {
            return this.field;
        }
        this.field = this.findField();
        return this.field;
    }

    private Optional<Field> findField() {
        if (this.type instanceof ProductCmptType && this.changingOverTime) {
            return ((ProductCmptType)this.type).findDeclaredFieldFromGeneration(this.annotationClass, this.matcher);
        }
        return this.type.findDeclaredField(this.annotationClass, this.matcher);
    }

    static class ModelDefaultValue
    extends FieldFinder<IpsDefaultValue, Object> {
        ModelDefaultValue(Type type, String attributeName, boolean changingOverTime) {
            super(type, IpsDefaultValue.class, a -> a.value().equals(attributeName), changingOverTime);
        }
    }

    static class ModelValueSet
    extends FieldFinder<IpsAllowedValues, ValueSet<?>> {
        ModelValueSet(Type type, String attributeName, boolean changingOverTime) {
            super(type, IpsAllowedValues.class, a -> a.value().equals(attributeName), changingOverTime);
        }
    }
}

