/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type.read;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.faktorips.runtime.model.annotation.AnnotatedDeclaration;
import org.faktorips.runtime.model.type.ModelElement;
import org.faktorips.runtime.model.type.read.SimpleGetterMethodCollector;
import org.faktorips.runtime.model.type.read.TypePartsReader;

public class SimpleTypePartsReader<E extends ModelElement, P extends Annotation, C extends Annotation> {
    private SimpleGetterMethodCollector<E, P, C> collector;
    private TypePartsReader typePartsReader;
    private Class<P> parentAnnotation;

    public SimpleTypePartsReader(Class<P> parentAnnotation, NamesAccessor<P> namesAccessor, Class<C> childAnnotation, NameAccessor<C> nameAccessor, ModelElementCreator<E> modelElementCreator) {
        this.parentAnnotation = parentAnnotation;
        this.collector = new SimpleGetterMethodCollector<E, P, C>(parentAnnotation, namesAccessor, childAnnotation, nameAccessor, modelElementCreator);
        this.typePartsReader = new TypePartsReader(this.collector);
    }

    public LinkedHashMap<String, E> createParts(Class<?> annotatedClass, ModelElement parentModel) {
        return this.createParts(annotatedClass, annotatedClass, parentModel);
    }

    public LinkedHashMap<String, E> createParts(Class<?> classWithChildNameList, Class<?> classWithGetterMethods, ModelElement parentModel) {
        this.typePartsReader.init(AnnotatedDeclaration.from(classWithChildNameList));
        this.readMethodsFromAnnotatedParentInterfaces(classWithGetterMethods);
        this.typePartsReader.read(AnnotatedDeclaration.from(classWithGetterMethods));
        return this.collector.createParts(parentModel);
    }

    private void readMethodsFromAnnotatedParentInterfaces(Class<?> classWithGetterMethods) {
        if (classWithGetterMethods.isInterface()) {
            LinkedList superInterfaces = new LinkedList();
            Class<?> superInterfaceWithParentAnnotation = this.findSuperInterfaceWithParentAnnotation(classWithGetterMethods);
            while (superInterfaceWithParentAnnotation != null) {
                superInterfaces.push(superInterfaceWithParentAnnotation);
                superInterfaceWithParentAnnotation = this.findSuperInterfaceWithParentAnnotation(superInterfaceWithParentAnnotation);
            }
            while (!superInterfaces.isEmpty()) {
                this.typePartsReader.read(AnnotatedDeclaration.from((Class)superInterfaces.pop()));
            }
        }
    }

    private Class<?> findSuperInterfaceWithParentAnnotation(Class<?> iface) {
        for (Class<?> superInterface : iface.getInterfaces()) {
            if (superInterface.isAnnotationPresent(this.parentAnnotation)) {
                return superInterface;
            }
            Class<?> interfaceWithAnnotation = this.findSuperInterfaceWithParentAnnotation(superInterface);
            if (interfaceWithAnnotation == null) continue;
            return interfaceWithAnnotation;
        }
        return null;
    }

    @FunctionalInterface
    public static interface NamesAccessor<A extends Annotation> {
        public String[] getNames(A var1);
    }

    @FunctionalInterface
    public static interface NameAccessor<C extends Annotation> {
        public String getName(C var1);
    }

    @FunctionalInterface
    public static interface ModelElementCreator<T extends ModelElement> {
        public T create(ModelElement var1, String var2, Method var3);
    }
}

