/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.productswitch;

import java.util.List;
import org.faktorips.runtime.IConfigurableModelObject;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.model.type.PolicyAssociation;
import org.faktorips.runtime.productswitch.ProductFinderResult;
import org.faktorips.runtime.productswitch.ProductSwitch;

@FunctionalInterface
public interface AdvancedProductFinder {
    public static final AdvancedProductFinder BY_KIND_ID = (parent, oldParentProdCmpt, child, parentToChild) -> {
        List<IProductComponent> matches = parentToChild.getMatchingAssociation().getTargetObjects(parent.getProductComponent(), parent.getEffectiveFromAsCalendar()).stream().filter(c -> child.getProductComponent().getKindId().equals(c.getKindId())).toList();
        if (matches.isEmpty()) {
            return ProductSwitch.createEmptyResult(child);
        }
        if (matches.size() == 1) {
            return ProductFinderResult.of(matches.get(0));
        }
        return ProductSwitch.createErrorResult(child, matches);
    };

    public ProductFinderResult findMatchingProduct(IConfigurableModelObject var1, IProductComponent var2, IConfigurableModelObject var3, PolicyAssociation var4);

    default public AdvancedProductFinder or(AdvancedProductFinder other) {
        return (parent, oldParentProdCmpt, child, parentToChild) -> {
            ProductFinderResult result = this.findMatchingProduct(parent, oldParentProdCmpt, child, parentToChild);
            if (!result.isEmpty() || result.isError()) {
                return result;
            }
            return other.findMatchingProduct(parent, oldParentProdCmpt, child, parentToChild);
        };
    }
}

