/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.productswitch;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.faktorips.runtime.IConfigurableModelObject;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.model.IpsModel;
import org.faktorips.runtime.model.type.AssociationKind;
import org.faktorips.runtime.model.type.PolicyAssociation;
import org.faktorips.runtime.model.type.PolicyCmptType;
import org.faktorips.runtime.model.type.ProductAssociation;
import org.faktorips.runtime.model.type.ProductCmptType;
import org.faktorips.runtime.productswitch.AdvancedProductFinder;
import org.faktorips.runtime.productswitch.MatchingProductFinder;
import org.faktorips.runtime.productswitch.ProductFinderResult;
import org.faktorips.runtime.productswitch.ProductSwitchResults;

public class ProductSwitch {
    public static final BiPredicate<IProductComponent, IProductComponent> BY_KIND_ID = (oldP, newP) -> oldP.getKindId().equals(newP.getKindId());

    private ProductSwitch() {
    }

    public static ProductSwitchCondition from(IConfigurableModelObject modelObject) {
        return new ProductSwitchCondition(modelObject);
    }

    public static ProductFinderResult createErrorResult(IConfigurableModelObject modelObject, List<IProductComponent> matchingProductComponents) {
        String message = MessageFormat.format("Target {0} has multiple replacements {1}", modelObject.toString(), matchingProductComponents.stream().map(Object::toString).collect(Collectors.joining(" ", ", ", ".")));
        return ProductFinderResult.error(message);
    }

    public static ProductFinderResult createEmptyResult(IConfigurableModelObject modelObject) {
        String message = MessageFormat.format("Target {0} has no suitable replacements.", modelObject.toString());
        return ProductFinderResult.empty(message);
    }

    private static boolean isProductConfiguredComposition(PolicyAssociation policyAssociation) {
        return policyAssociation.getAssociationKind() == AssociationKind.Composition && policyAssociation.getType().isConfiguredByProductCmptType();
    }

    public static class ProductSwitchCondition {
        private final IConfigurableModelObject rootModelObject;

        private ProductSwitchCondition(IConfigurableModelObject modelObject) {
            this.rootModelObject = modelObject;
        }

        public MatchingProductFinderSwitch with(BiPredicate<IProductComponent, IProductComponent> howToMatch) {
            return new MatchingProductFinderSwitch(this.rootModelObject, howToMatch);
        }

        public MatchingProductFinderSwitch matchingBy(String attributeName) {
            BiPredicate<IProductComponent, IProductComponent> howToMatch = (oldP, newP) -> {
                Object oldValue = IpsModel.getProductCmptType(oldP).getAttribute(attributeName).getValue((IProductComponent)oldP, this.rootModelObject.getEffectiveFromAsCalendar());
                Object newValue = IpsModel.getProductCmptType(newP).getAttribute(attributeName).getValue((IProductComponent)newP, this.rootModelObject.getEffectiveFromAsCalendar());
                return oldValue != null && oldValue.equals(newValue);
            };
            return new MatchingProductFinderSwitch(this.rootModelObject, howToMatch);
        }

        public MatchingProductFinderSwitch with(MatchingProductFinder productFinder) {
            return new MatchingProductFinderSwitch(this.rootModelObject, productFinder);
        }

        public MatchingProductFinderSwitch matchingBy(ProductCmptType productCmptType, String attributeName) {
            MatchingProductFinder productFinder = (childModel, oldChildProducts, newChildProducts) -> {
                if (oldChildProducts.size() == 1 && newChildProducts.size() == 1) {
                    return ProductFinderResult.of((IProductComponent)newChildProducts.get(0));
                }
                ProductCmptType oldProductCmptType = IpsModel.getProductCmptType(childModel.getProductComponent());
                if (!oldProductCmptType.isSameOrSub(productCmptType)) {
                    return ProductFinderResult.empty(MessageFormat.format("ProductCmptType {0} of Target {1} does not match {2}", oldProductCmptType, childModel, productCmptType));
                }
                Object oldValue = oldProductCmptType.getAttribute(attributeName).getValue(childModel.getProductComponent(), childModel.getEffectiveFromAsCalendar());
                ArrayList<IProductComponent> matching = new ArrayList<IProductComponent>();
                for (IProductComponent newChildProduct : newChildProducts) {
                    ProductCmptType newProductCmptType = IpsModel.getProductCmptType(newChildProduct);
                    if (!newProductCmptType.isSameOrSub(productCmptType)) continue;
                    Object newValue = newProductCmptType.getAttribute(attributeName).getValue(newChildProduct, childModel.getEffectiveFromAsCalendar());
                    if (oldValue == null || !oldValue.equals(newValue)) continue;
                    matching.add(newChildProduct);
                }
                if (matching.size() == 1) {
                    return ProductFinderResult.of((IProductComponent)matching.get(0));
                }
                if (matching.isEmpty()) {
                    return ProductSwitch.createEmptyResult(childModel);
                }
                return ProductSwitch.createErrorResult(childModel, matching);
            };
            return new MatchingProductFinderSwitch(this.rootModelObject, productFinder);
        }

        public ProductSwitchResults to(IProductComponent newProduct) {
            return new MatchingProductFinderSwitch(this.rootModelObject, BY_KIND_ID).to(newProduct);
        }

        public MultipleProductSwitchCondition switchAt(PolicyAssociation association, AdvancedProductFinder finder) {
            return new MultipleProductSwitchCondition(this.rootModelObject, association, finder);
        }

        public AdvancedProductFinderSwitch with(AdvancedProductFinder finder) {
            return new AdvancedProductFinderSwitch(this.rootModelObject, finder);
        }
    }

    public static abstract class AbstractProductFinderSwitch {
        private final IConfigurableModelObject rootModelObject;

        private AbstractProductFinderSwitch(IConfigurableModelObject modelObject) {
            this.rootModelObject = modelObject;
        }

        public ProductSwitchResults to(IProductComponent newProduct) {
            LinkedHashMap<IConfigurableModelObject, ProductSwitchResults.ProductSwitchResult> result = new LinkedHashMap<IConfigurableModelObject, ProductSwitchResults.ProductSwitchResult>();
            this.switchProduct(this.rootModelObject, newProduct, result);
            return new ProductSwitchResults(result);
        }

        private void switchProduct(IConfigurableModelObject modelObject, IProductComponent newProduct, Map<IConfigurableModelObject, ProductSwitchResults.ProductSwitchResult> result) {
            IProductComponent oldProduct = modelObject.getProductComponent();
            modelObject.setProductComponent(newProduct);
            result.put(modelObject, new ProductSwitchResults.SuccessfulProductSwitch(oldProduct, newProduct));
            PolicyCmptType policyCmptType = IpsModel.getPolicyCmptType(modelObject);
            Calendar effectiveDate = modelObject.getEffectiveFromAsCalendar();
            policyCmptType.getAssociations().forEach(policyAssociation -> {
                ProductAssociation productAssociation = policyAssociation.getMatchingAssociation();
                if (ProductSwitch.isProductConfiguredComposition(policyAssociation) && !policyAssociation.isDerivedUnion() && productAssociation != null) {
                    List<IProductComponent> oldChildProducts = productAssociation.getTargetObjects(oldProduct, effectiveDate);
                    List<IProductComponent> newChildProducts = productAssociation.getTargetObjects(newProduct, effectiveDate);
                    policyAssociation.getTargetObjects(modelObject).stream().filter(IConfigurableModelObject.class::isInstance).map(IConfigurableModelObject.class::cast).forEach(child -> {
                        ProductFinderResult match = this.findMatchingProduct(modelObject, (IConfigurableModelObject)child, oldChildProducts, newChildProducts, oldProduct, (PolicyAssociation)policyAssociation);
                        if (match.isError() || match.isEmpty()) {
                            result.put((IConfigurableModelObject)child, new ProductSwitchResults.FailedProductSwitch(modelObject, (PolicyAssociation)policyAssociation, match.getMessage()));
                        } else {
                            this.switchProduct((IConfigurableModelObject)child, match.getProductComponent(), result);
                        }
                    });
                }
            });
        }

        abstract ProductFinderResult findMatchingProduct(IConfigurableModelObject var1, IConfigurableModelObject var2, List<IProductComponent> var3, List<IProductComponent> var4, IProductComponent var5, PolicyAssociation var6);
    }

    public static class MatchingProductFinderSwitch
    extends AbstractProductFinderSwitch {
        private final MatchingProductFinder productFinder;

        private MatchingProductFinderSwitch(IConfigurableModelObject modelObject, BiPredicate<IProductComponent, IProductComponent> howToMatch) {
            this(modelObject, (IConfigurableModelObject childModel, List<IProductComponent> oldChildProducts, List<IProductComponent> newChildProducts) -> {
                if (oldChildProducts.size() == 1 && newChildProducts.size() == 1) {
                    return ProductFinderResult.of((IProductComponent)newChildProducts.get(0));
                }
                List<IProductComponent> matching = newChildProducts.stream().filter(newChildProduct -> howToMatch.test(childModel.getProductComponent(), (IProductComponent)newChildProduct)).toList();
                if (matching.isEmpty()) {
                    return ProductSwitch.createEmptyResult(childModel);
                }
                if (matching.size() == 1) {
                    return ProductFinderResult.of(matching.get(0));
                }
                return ProductSwitch.createErrorResult(childModel, matching);
            });
        }

        private MatchingProductFinderSwitch(IConfigurableModelObject modelObject, MatchingProductFinder productFinder) {
            super(modelObject);
            this.productFinder = productFinder;
        }

        @Override
        ProductFinderResult findMatchingProduct(IConfigurableModelObject parent, IConfigurableModelObject child, List<IProductComponent> oldChildProducts, List<IProductComponent> newChildProducts, IProductComponent oldParentProduct, PolicyAssociation policyAssociation) {
            return this.productFinder.findMatchingProduct(child, oldChildProducts, newChildProducts);
        }
    }

    public static class AdvancedProductFinderSwitch
    extends AbstractProductFinderSwitch {
        private final Map<PolicyAssociation, AdvancedProductFinder> finders = new HashMap<PolicyAssociation, AdvancedProductFinder>();

        private AdvancedProductFinderSwitch(IConfigurableModelObject modelObject, Map<PolicyAssociation, AdvancedProductFinder> finders) {
            super(modelObject);
            this.finders.putAll(finders);
        }

        private AdvancedProductFinderSwitch(IConfigurableModelObject modelObject, AdvancedProductFinder finder) {
            super(modelObject);
            this.finders.put(null, finder);
        }

        @Override
        ProductFinderResult findMatchingProduct(IConfigurableModelObject parent, IConfigurableModelObject child, List<IProductComponent> oldChildProducts, List<IProductComponent> newChildProducts, IProductComponent oldParentProduct, PolicyAssociation policyAssociation) {
            AdvancedProductFinder productFinder = this.finders.get(policyAssociation);
            if (productFinder == null) {
                productFinder = this.finders.get(null);
            }
            return productFinder.findMatchingProduct(parent, oldParentProduct, child, policyAssociation);
        }
    }

    public static class MultipleProductSwitchCondition {
        private final IConfigurableModelObject rootModelObject;
        private final Map<PolicyAssociation, AdvancedProductFinder> finders = new HashMap<PolicyAssociation, AdvancedProductFinder>();

        private MultipleProductSwitchCondition(IConfigurableModelObject modelObject, PolicyAssociation association, AdvancedProductFinder finder) {
            this.rootModelObject = modelObject;
            this.finders.put(association, finder);
        }

        public MultipleProductSwitchCondition switchAt(PolicyAssociation association, AdvancedProductFinder finder) {
            this.finders.put(association, finder);
            return this;
        }

        public AdvancedProductFinderSwitch switchOthers(AdvancedProductFinder finder) {
            this.finders.put(null, finder);
            return new AdvancedProductFinderSwitch(this.rootModelObject, this.finders);
        }

        public AdvancedProductFinderSwitch elseUseDefault() {
            this.finders.put(null, AdvancedProductFinder.BY_KIND_ID);
            return new AdvancedProductFinderSwitch(this.rootModelObject, this.finders);
        }
    }
}

