/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.productswitch;

import org.faktorips.runtime.IProductComponent;

public class ProductFinderResult {
    private final IProductComponent productComponent;
    private final boolean error;
    private final String message;

    private ProductFinderResult(IProductComponent productComponent) {
        this.productComponent = productComponent;
        this.error = false;
        this.message = null;
    }

    private ProductFinderResult(String message, boolean error) {
        this.productComponent = null;
        this.error = error;
        this.message = message;
    }

    public static ProductFinderResult of(IProductComponent productComponent) {
        return new ProductFinderResult(productComponent);
    }

    public static ProductFinderResult error(String message) {
        return new ProductFinderResult(message, true);
    }

    public static ProductFinderResult empty(String message) {
        return new ProductFinderResult(message, false);
    }

    public IProductComponent getProductComponent() {
        return this.productComponent;
    }

    public boolean isError() {
        return this.error;
    }

    public boolean isEmpty() {
        return this.productComponent == null;
    }

    public boolean isPresent() {
        return !this.error && !this.isEmpty();
    }

    public String getMessage() {
        return this.message;
    }
}

