/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.xml;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.xml.IIpsXmlAdapter;

public interface IIpsLocalTimeAdapter
extends IIpsXmlAdapter<String, LocalTime> {
    @Override
    default public LocalTime unmarshal(String v) {
        if (IpsStringUtils.isBlank(v)) {
            return null;
        }
        try {
            return LocalTime.parse(v);
        }
        catch (DateTimeParseException e) {
            LocalTime localTimeWithMilliseconds = DateTimeFormatter.ofPattern("HH:mm:ss:SSS").parse((CharSequence)v, LocalTime::from);
            return localTimeWithMilliseconds.withNano(0);
        }
    }

    @Override
    default public String marshal(LocalTime v) {
        if (v == null) {
            return null;
        }
        return v.toString();
    }
}

