/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.internal.EnumValues;
import org.faktorips.runtime.internal.InternationalStringXmlReaderWriter;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.internal.PropertiesReadingInternationalString;
import org.faktorips.runtime.internal.Range;
import org.faktorips.runtime.internal.XmlUtil;
import org.faktorips.runtime.model.IpsModel;
import org.faktorips.runtime.model.type.ProductCmptType;
import org.faktorips.runtime.util.MessagesHelper;
import org.faktorips.values.DefaultInternationalString;
import org.faktorips.values.InternationalString;
import org.faktorips.values.LocalizedString;
import org.faktorips.valueset.StringLengthValueSet;
import org.faktorips.valueset.UnrestrictedValueSet;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class ValueToXmlHelper
extends Enum<ValueToXmlHelper> {
    public static final String XML_TAG_VALUE = "Value";
    public static final String XML_TAG_VALUE_SET = "ValueSet";
    public static final String XML_TAG_DATA = "Data";
    public static final String LEGACY_XML_TAG_CONFIG_ELEMENT = "ConfigElement";
    public static final String CONFIGURED_DEFAULT_PREFIX = "@default_";
    public static final String CONFIGURED_VALUE_SET_PREFIX = "@valueSet_";
    public static final String XML_TAG_CONFIGURED_DEFAULT = "ConfiguredDefault";
    public static final String XML_TAG_CONFIGURED_VALUE_SET = "ConfiguredValueSet";
    public static final String XML_TAG_ATTRIBUTE_VALUE = "AttributeValue";
    public static final String XML_ATTRIBUTE_ATTRIBUTE = "attribute";
    public static final String XML_TAG_ALL_VALUES = "AllValues";
    public static final String XML_TAG_STRINGLENGTH = "StringLength";
    public static final String XML_TAG_DERIVED = "Derived";
    public static final String XML_TAG_ENUM = "Enum";
    public static final String XML_TAG_RANGE = "Range";
    public static final String XML_TAG_STEP = "Step";
    public static final String XML_TAG_UPPER_BOUND = "UpperBound";
    public static final String XML_TAG_LOWER_BOUND = "LowerBound";
    public static final String XML_TAG_TABLE_CONTENT_NAME = "TableContentName";
    public static final String XML_TAG_TABLE_CONTENT_USAGE = "TableContentUsage";
    public static final String XML_TAG_MAXIMUM_LENGTH = "MaximumLength";
    public static final String XML_TAG_ROW = "Row";
    public static final String XML_TAG_ROWS = "Rows";
    public static final String XML_TAG_COLUMN_TABLE_REFERENCE = "ColumnTableReference";
    public static final String XML_TAG_DESCRIPTION = "Description";
    public static final String XML_ATTRIBUTE_STRUCTURE_USAGE = "structureUsage";
    public static final String XML_ATTRIBUTE_ABSTRACT = "abstract";
    public static final String XML_ATTRIBUTE_IS_NULL = "isNull";
    public static final String XML_ATTRIBUTE_CONTAINS_NULL = "containsNull";
    public static final String XML_ATTRIBUTE_EMPTY = "empty";
    private static final /* synthetic */ ValueToXmlHelper[] $VALUES;

    public static ValueToXmlHelper[] values() {
        return (ValueToXmlHelper[])$VALUES.clone();
    }

    public static ValueToXmlHelper valueOf(String name) {
        return Enum.valueOf(ValueToXmlHelper.class, name);
    }

    public static void addValueToElement(String value, Element el, String tagName) {
        ValueToXmlHelper.addValueAndReturnElement(value, el, tagName, false);
    }

    public static void addInternationalStringToElement(DefaultInternationalString value, Element el, String tagName) {
        ValueToXmlHelper.addInternationalStringAndReturnElement(value, el, tagName);
    }

    public static void addCDataValueToElement(String value, Element el, String tagName) {
        ValueToXmlHelper.addValueAndReturnElement(value, el, tagName, true);
    }

    public static Element deleteExistingElementAndCreateNewElement(Element element, String tagName, String attributeName) {
        NodeList nodes = element.getElementsByTagName(tagName);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element node = (Element)nodes.item(i);
            if (!node.getAttribute(XML_ATTRIBUTE_ATTRIBUTE).equals(attributeName)) continue;
            element.removeChild(node);
            break;
        }
        Element newElement = element.getOwnerDocument().createElement(tagName);
        newElement.setAttribute(XML_ATTRIBUTE_ATTRIBUTE, attributeName);
        element.appendChild(newElement);
        return newElement;
    }

    private static Element addValueAndReturnElement(String value, Element el, String tagName, boolean useCDataSection) {
        Document ownerDocument = el.getOwnerDocument();
        Element valueEl = ValueToXmlHelper.createValueElement(value, tagName, ownerDocument, useCDataSection);
        el.appendChild(valueEl);
        return valueEl;
    }

    private static Element addInternationalStringAndReturnElement(DefaultInternationalString value, Element el, String tagName) {
        Document ownerDocument = el.getOwnerDocument();
        Element valueEl = ownerDocument.createElement(tagName);
        Element internationalStringEl = InternationalStringXmlReaderWriter.toXml(ownerDocument, value);
        valueEl.appendChild(internationalStringEl);
        el.appendChild(valueEl);
        return valueEl;
    }

    public static Element createValueElement(String value, String tagName, Document ownerDocument, boolean useCDataSection) {
        Element valueEl = ownerDocument.createElement(tagName);
        ValueToXmlHelper.setValue(value, ownerDocument, useCDataSection, valueEl);
        return valueEl;
    }

    public static void setValue(String value, Element valueEl) {
        ValueToXmlHelper.setValue(value, valueEl.getOwnerDocument(), false, valueEl);
    }

    private static void setValue(String value, Document ownerDocument, boolean useCDataSection, Element valueEl) {
        if (value == null) {
            valueEl.setAttribute(XML_ATTRIBUTE_IS_NULL, Boolean.TRUE.toString());
        } else if (useCDataSection) {
            valueEl.appendChild(ownerDocument.createCDATASection(value));
        } else {
            valueEl.appendChild(ownerDocument.createTextNode(value));
        }
    }

    public static Element addValueAndReturnElement(String value, Element el, String tagName) {
        return ValueToXmlHelper.addValueAndReturnElement(value, el, tagName, false);
    }

    public static void addTableUsageToElement(Element el, String structureUsage, String tableContentName) {
        Element tableContentElement = el.getOwnerDocument().createElement(XML_TAG_TABLE_CONTENT_USAGE);
        tableContentElement.setAttribute(XML_ATTRIBUTE_STRUCTURE_USAGE, structureUsage);
        ValueToXmlHelper.addValueToElement(tableContentName, tableContentElement, XML_TAG_TABLE_CONTENT_NAME);
        el.appendChild(tableContentElement);
    }

    public static String getValueFromElement(Element el, String tagName) {
        return XmlUtil.findFirstElement(el, tagName).map(ValueToXmlHelper::getValueFromElement).orElse(null);
    }

    @Deprecated(forRemoval=true, since="25.7")
    public static DefaultInternationalString getInternationalStringFromElement(Element el, String tagName) {
        Collection<LocalizedString> localizedStrings = InternationalStringXmlReaderWriter.fromXml(el, tagName);
        Locale defaultLocale = InternationalStringXmlReaderWriter.defaultLocaleFromXml(el, tagName);
        return new DefaultInternationalString(localizedStrings, defaultLocale);
    }

    public static DefaultInternationalString getInternationalStringFromElement(Element el, String tagName, IProductComponent productComponent, String propertyName) {
        Collection<LocalizedString> localizedStrings = InternationalStringXmlReaderWriter.fromXml(el, tagName);
        Locale defaultLocale = InternationalStringXmlReaderWriter.defaultLocaleFromXml(el, tagName);
        InternationalString fallback = ValueToXmlHelper.createExternalI18nFallback(productComponent, propertyName);
        return new DefaultInternationalString(localizedStrings, defaultLocale, fallback);
    }

    private static InternationalString createExternalI18nFallback(IProductComponent productComponent, String propertyName) {
        ProductCmptType productCmptType = IpsModel.getProductCmptType(productComponent);
        MessagesHelper messagesHelper = productCmptType.getMessageHelper().forI18n();
        String key = productComponent.getId().replace(' ', '_') + "." + propertyName;
        return new PropertiesReadingInternationalString(key, messagesHelper);
    }

    public static String getValueFromElement(Element valueEl) {
        if (Boolean.parseBoolean(valueEl.getAttribute(XML_ATTRIBUTE_IS_NULL))) {
            return null;
        }
        Text text = XmlUtil.getTextNode(valueEl);
        if (text != null) {
            return text.getData();
        }
        CDATASection cdata = XmlUtil.getFirstCDataSection(valueEl);
        String result = "";
        if (cdata != null) {
            result = cdata.getData();
        }
        return result;
    }

    @Deprecated(forRemoval=true, since="25.7")
    public static DefaultInternationalString getInternationalStringFromElement(Element el) {
        Collection<LocalizedString> localizedString = InternationalStringXmlReaderWriter.fromXml(el);
        Locale defaultLocale = InternationalStringXmlReaderWriter.defaultLocaleFromXml(el);
        return new DefaultInternationalString(localizedString, defaultLocale);
    }

    public static DefaultInternationalString getInternationalStringFromElement(Element el, IProductComponent productComponent, String propertyName) {
        Collection<LocalizedString> localizedString = InternationalStringXmlReaderWriter.fromXml(el);
        Locale defaultLocale = InternationalStringXmlReaderWriter.defaultLocaleFromXml(el);
        InternationalString fallback = ValueToXmlHelper.createExternalI18nFallback(productComponent, propertyName);
        return new DefaultInternationalString(localizedString, defaultLocale, fallback);
    }

    public static Range getRangeFromElement(Element el, String tagName) {
        Optional<Element> valueSetEl = XmlUtil.findFirstElement(el, tagName);
        Optional<Range> rangeEl = valueSetEl.flatMap(v -> XmlUtil.findFirstElement(v, XML_TAG_RANGE));
        if (rangeEl.filter(r -> ValueToXmlHelper.isAttributeTrue(r, XML_ATTRIBUTE_EMPTY)).isPresent()) {
            return new Range();
        }
        return rangeEl.map(r -> {
            boolean containsNull = ValueToXmlHelper.isAttributeTrue(r, XML_ATTRIBUTE_CONTAINS_NULL);
            String lowerBound = ValueToXmlHelper.getValueFromElement(r, XML_TAG_LOWER_BOUND);
            String upperBound = ValueToXmlHelper.getValueFromElement(r, XML_TAG_UPPER_BOUND);
            String step = ValueToXmlHelper.getValueFromElement(r, XML_TAG_STEP);
            return new Range(lowerBound, upperBound, step, containsNull);
        }).orElse(null);
    }

    public static EnumValues getEnumValueSetFromElement(Element el, String tagName) {
        Optional<Element> valueSetEl = XmlUtil.findFirstElement(el, tagName);
        Optional<EnumValues> enumEl = valueSetEl.flatMap(v -> XmlUtil.findFirstElement(v, XML_TAG_ENUM));
        return enumEl.map(e -> {
            NodeList valueElements = e.getElementsByTagName(XML_TAG_VALUE);
            String[] values = new String[valueElements.getLength()];
            boolean containsNull = false;
            for (int i = 0; i < valueElements.getLength(); ++i) {
                Element valueEl = (Element)valueElements.item(i);
                values[i] = ValueToXmlHelper.getValueFromElement(valueEl, XML_TAG_DATA);
                if (values[i] != null) continue;
                containsNull = true;
            }
            return new EnumValues(values, containsNull);
        }).orElse(null);
    }

    public static StringLengthValueSet getStringLengthValueSetFromElement(Element el, String tagName) {
        Optional<Element> valueSetEl = XmlUtil.findFirstElement(el, tagName);
        Optional<StringLengthValueSet> stringLengthEl = valueSetEl.flatMap(v -> XmlUtil.findFirstElement(v, XML_TAG_STRINGLENGTH));
        return stringLengthEl.map(s -> {
            Element maximumLengthEl = XmlUtil.getFirstElement(s, XML_TAG_MAXIMUM_LENGTH);
            String textContent = maximumLengthEl.getTextContent();
            Integer maximumLength = IpsStringUtils.isBlank(textContent) ? null : Integer.valueOf(textContent);
            boolean containsNull = ValueToXmlHelper.isAttributeTrue(s, XML_ATTRIBUTE_CONTAINS_NULL);
            return new StringLengthValueSet(maximumLength, containsNull);
        }).orElse(null);
    }

    public static <T> UnrestrictedValueSet<T> getUnrestrictedValueSet(Element el, String tagName) {
        Optional<Element> valueSetEl = XmlUtil.findFirstElement(el, tagName);
        Optional<Element> enumEl = valueSetEl.flatMap(v -> XmlUtil.findFirstElement(v, XML_TAG_ALL_VALUES)).filter(e -> e.hasAttribute(XML_ATTRIBUTE_CONTAINS_NULL));
        Optional<UnrestrictedValueSet> valueSet = enumEl.map($ -> {
            boolean containsNull = ValueToXmlHelper.isAttributeTrue((Element)enumEl.get(), XML_ATTRIBUTE_CONTAINS_NULL);
            return new UnrestrictedValueSet(containsNull);
        });
        return valueSet.orElse(new UnrestrictedValueSet(true));
    }

    public static boolean isAttributeTrue(Element element, String attribute) {
        return Boolean.parseBoolean(element.getAttribute(attribute));
    }

    private static /* synthetic */ ValueToXmlHelper[] $values() {
        return new ValueToXmlHelper[0];
    }

    static {
        $VALUES = ValueToXmlHelper.$values();
    }
}

