/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.IProductObject;
import org.faktorips.runtime.IValidationContext;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.internal.FormulaUtil;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.internal.ProductComponent;
import org.faktorips.runtime.internal.ProductComponentGeneration;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.model.annotation.IpsFormula;
import org.faktorips.runtime.model.type.Deprecation;
import org.faktorips.runtime.model.type.Type;
import org.faktorips.runtime.model.type.TypePart;

public class Formula
extends TypePart {
    public static final String MSGCODE_REQUIRED_FORMULA_IS_EMPTY = "MSGCODE_REQUIRED_FORMULA_IS_EMPTY";
    public static final String MSGKEY_REQUIRED_FORMULA_IS_EMPTY = "Formula.RequiredFormulaIsEmpty";
    public static final String PROPERTY_REQUIRED_FORMULA = "requiredFormula";
    private final IpsFormula annotation;
    private final Method getter;
    private final boolean changingOverTime;

    public Formula(Type type, Method getter, boolean changingOverTime) {
        super(getter.getAnnotation(IpsFormula.class).name(), type, getter.getAnnotation(IpsExtensionProperties.class), Deprecation.of(getter));
        this.annotation = getter.getAnnotation(IpsFormula.class);
        this.getter = getter;
        this.changingOverTime = changingOverTime;
    }

    @Override
    public boolean isChangingOverTime() {
        return this.changingOverTime;
    }

    public String getFormulaText(IProductComponent productComponent, @CheckForNull Calendar effectiveDate) {
        IProductObject relevantProductObject = Formula.getRelevantProductObject(productComponent, effectiveDate, this.isChangingOverTime());
        if (relevantProductObject instanceof ProductComponent) {
            ProductComponent productCmpt = (ProductComponent)relevantProductObject;
            return FormulaUtilAccess.getFormulaText(productCmpt, this.getFormulaName());
        }
        return FormulaUtilAccess.getFormulaText((ProductComponentGeneration)relevantProductObject, this.getFormulaName());
    }

    public void setFormulaText(IProductComponent productComponent, @CheckForNull Calendar effectiveDate, String formulaText) {
        this.setFormulaText(Formula.getRelevantProductObject(productComponent, effectiveDate, this.isChangingOverTime()), formulaText);
    }

    public void setFormulaText(IProductComponentGeneration generation, String formulaText) {
        this.setFormulaText(Formula.getRelevantProductObject(generation, this.isChangingOverTime()), formulaText);
    }

    private void setFormulaText(IProductObject productObject, String formulaText) {
        if (productObject instanceof ProductComponent) {
            ProductComponent productCmpt = (ProductComponent)productObject;
            FormulaUtilAccess.setFormulaText(productCmpt, this.getFormulaName(), formulaText);
        } else {
            FormulaUtilAccess.setFormulaText((ProductComponentGeneration)productObject, this.getFormulaName(), formulaText);
        }
    }

    public String getFormulaName() {
        return this.annotation.name();
    }

    public boolean isRequired() {
        return this.annotation.required();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getFormulaName());
        sb.append("(");
        sb.append(Stream.of(this.getter.getParameterTypes()).map(Class::getSimpleName).collect(Collectors.joining(", ")));
        sb.append(")");
        sb.append(": ");
        sb.append(this.getter.getReturnType());
        return sb.toString();
    }

    @Override
    public void validate(MessageList list, IValidationContext context, IProductComponent productComponent, Calendar effectiveDate) {
        ResourceBundle messages = ResourceBundle.getBundle(Formula.class.getName(), context.getLocale());
        String formatString = String.format(messages.getString(MSGKEY_REQUIRED_FORMULA_IS_EMPTY), this.getLabel(context.getLocale()), productComponent.getId());
        if (this.isRequired() && IpsStringUtils.isEmpty(this.getFormulaText(productComponent, effectiveDate))) {
            list.newError(MSGCODE_REQUIRED_FORMULA_IS_EMPTY, formatString, new ObjectProperty(this, PROPERTY_REQUIRED_FORMULA), new ObjectProperty(productComponent, this.getName()));
        }
    }

    private static class FormulaUtilAccess
    extends FormulaUtil {
        private FormulaUtilAccess() {
        }

        private static String getFormulaText(ProductComponent product, String formulaSignature) {
            return FormulaUtil.getFormula(product, formulaSignature);
        }

        private static void setFormulaText(ProductComponent product, String formulaSignature, String formulaText) {
            FormulaUtil.setFormula(product, formulaSignature, formulaText);
        }

        private static String getFormulaText(ProductComponentGeneration productGeneration, String formulaSignature) {
            return FormulaUtil.getFormula(productGeneration, formulaSignature);
        }

        private static void setFormulaText(ProductComponentGeneration productGeneration, String formulaSignature, String formulaText) {
            FormulaUtil.setFormula(productGeneration, formulaSignature, formulaText);
        }
    }
}

