/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.util;

import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.faktorips.annotation.UtilityClass;
import org.faktorips.values.NullObject;

@UtilityClass
public class MessagesHelper {
    private String name;
    private ClassLoader loader;
    private final Locale defaultLocale;
    private volatile MessagesHelper i18nMessagesHelper;

    public MessagesHelper(String qualifiedName, ClassLoader loader, Locale defaultLocale) {
        this.name = qualifiedName;
        this.loader = loader;
        this.defaultLocale = defaultLocale;
    }

    public MessagesHelper forI18n() {
        MessagesHelper result = this.i18nMessagesHelper;
        if (result == null) {
            this.i18nMessagesHelper = result = new MessagesHelper(this, this.name.substring(0, this.name.lastIndexOf(46) + 1) + "i18n", this.loader, this.defaultLocale){

                @Override
                public String getMessage(String key, Locale locale) {
                    try {
                        return super.getMessage(key, locale);
                    }
                    catch (MissingResourceException e) {
                        return null;
                    }
                }
            };
        }
        return result;
    }

    public String getMessage(String key, Locale locale) {
        return this.getMessageInternal(key, locale);
    }

    private String getMessageInternal(String key, Locale locale) {
        try {
            return ResourceBundle.getBundle(this.name, locale, this.loader).getString(key);
        }
        catch (MissingResourceException e) {
            return ResourceBundle.getBundle(this.name, this.defaultLocale, this.loader).getString(key);
        }
    }

    public String getMessage(String key, Locale locale, Object ... replacements) {
        String s = this.getMessage(key, locale);
        IpsMessageFormat mf = new IpsMessageFormat(s, locale);
        return mf.format(replacements);
    }

    public String getMessageOr(String key, Locale locale, String fallBack) {
        try {
            return this.getMessageInternal(key, locale);
        }
        catch (MissingResourceException e) {
            return fallBack;
        }
    }

    private static class IpsMessageFormat
    extends Format {
        private static final long serialVersionUID = 1L;
        private final MessageFormat delegateFormat;

        public IpsMessageFormat(String pattern, Locale locale) {
            this.delegateFormat = new MessageFormat(pattern, locale);
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            if (obj.getClass().isArray()) {
                return this.delegateFormat.format(this.handleNullObjects((Object[])obj), toAppendTo, pos);
            }
            return this.delegateFormat.format(this.handleNullObject(obj), toAppendTo, pos);
        }

        private Object[] handleNullObjects(Object[] arguments) {
            Object[] result = Arrays.copyOf(arguments, arguments.length);
            for (int i = 0; i < arguments.length; ++i) {
                result[i] = this.handleNullObject(arguments[i]);
            }
            return result;
        }

        private Object handleNullObject(Object argument) {
            if (argument instanceof NullObject) {
                return null;
            }
            return argument;
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return this.delegateFormat.parse(source, pos);
        }
    }
}

