
CREATE TABLE CONFIGURATION.FEATURES(
 "FEAT_UID"    VARCHAR(100) NOT NULL,
 "ENABLE"      INTEGER NOT NULL,
 "DESCRIPTION" VARCHAR(1000),
 "STRATEGY"    VARCHAR(1000),
 "EXPRESSION"  VARCHAR(255),
 "GROUPNAME"   VARCHAR(100),
  PRIMARY KEY(FEAT_UID)
);

CREATE TABLE CONFIGURATION.PROPERTIES (
 "PROPERTY_ID"  VARCHAR(100) NOT NULL,
 "CLAZZ"        VARCHAR(255) NOT NULL,
 "CURRENTVALUE" VARCHAR(255),
 "FIXEDVALUES"  VARCHAR(1000),
 "DESCRIPTION"  VARCHAR(1000),
 "FEAT_UID"     VARCHAR(100) REFERENCES CONFIGURATION.FEATURES("FEAT_UID"),
 PRIMARY KEY("PROPERTY_ID")
);

CREATE TABLE CONFIGURATION.CUSTOM_PROPERTIES (
 "PROPERTY_ID"  VARCHAR(100) NOT NULL,
 "CLAZZ"        VARCHAR(255) NOT NULL,
 "CURRENTVALUE" VARCHAR(255),
 "FIXEDVALUES"  VARCHAR(1000),
 "DESCRIPTION"  VARCHAR(1000),
 "FEAT_UID"     VARCHAR(100) REFERENCES CONFIGURATION.FEATURES("FEAT_UID"),
 PRIMARY KEY("PROPERTY_ID")
);

CREATE TABLE CONFIGURATION.ROLES (
 "FEAT_UID"  VARCHAR(100) NOT NULL REFERENCES CONFIGURATION.FEATURES("FEAT_UID"),
 "ROLE_NAME" VARCHAR(100) NOT NULL,
 PRIMARY KEY("FEAT_UID", "ROLE_NAME")
);

CREATE TABLE CONFIGURATION.AUDIT (
 "EVT_UUID" VARCHAR(40) NOT NULL,
 "EVT_TIME" TIMESTAMP NOT NULL,
 "EVT_TYPE" VARCHAR(30) NOT NULL,
 "EVT_NAME" VARCHAR(100) NOT NULL,
 "EVT_ACTION" VARCHAR(30) NOT NULL,
 "EVT_HOSTNAME" VARCHAR(100) NOT NULL,
 "EVT_SOURCE" VARCHAR(30) NOT NULL,
 "EVT_DURATION" INTEGER,
 "EVT_USER" VARCHAR(30),
 "EVT_VALUE" VARCHAR(100),
 "EVT_KEYS" VARCHAR(255),
 PRIMARY KEY("EVT_UUID", "EVT_TIME")
);
