/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.audit;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.ff4j.audit.Event;
import org.ff4j.audit.EventRejectedExecutionHandler;
import org.ff4j.audit.EventWorker;
import org.ff4j.audit.PublisherThreadFactory;
import org.ff4j.audit.repository.EventRepository;
import org.ff4j.audit.repository.InMemoryEventRepository;

public class EventPublisher {
    public static final int DEFAULT_QUEUE_CAPACITY = 100;
    public static final int DEFAULT_POOL_SIZE = 4;
    public static final long timeout = 2000L;
    private ExecutorService executor;
    private EventRepository repository;
    private final long submitTimeout;
    private final boolean shutdownExecutor;

    public EventPublisher() {
        this(100, 4, new InMemoryEventRepository());
    }

    public EventPublisher(EventRepository er) {
        this(100, 4, er);
    }

    public EventPublisher(int queueCapacity, int poolSize, EventRepository er) {
        this(queueCapacity, poolSize, er, 2000L);
    }

    public EventPublisher(int queueCapacity, int poolSize, EventRepository er, long submitTimeout) {
        ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(queueCapacity);
        EventRejectedExecutionHandler rej = new EventRejectedExecutionHandler();
        PublisherThreadFactory tFactorty = new PublisherThreadFactory();
        this.executor = new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, queue, tFactorty, rej);
        this.repository = er;
        this.submitTimeout = submitTimeout;
        this.shutdownExecutor = true;
    }

    public EventPublisher(EventRepository er, ExecutorService executorService) {
        this(er, executorService, 2000L);
    }

    public EventPublisher(EventRepository er, ExecutorService executorService, long submitTimeout) {
        this.repository = er;
        this.executor = executorService;
        this.submitTimeout = submitTimeout;
        this.shutdownExecutor = false;
    }

    public void publish(Event e) {
        try {
            EventWorker ew = new EventWorker(e, this.repository);
            Future<Boolean> check = this.executor.submit(ew);
            check.get(this.submitTimeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e1) {
            System.err.println("Cannot publish event " + e1.getMessage());
        }
    }

    public void stop() {
        if (this.shutdownExecutor) {
            this.executor.shutdownNow();
        }
    }

    public void setRepository(EventRepository repository) {
        this.repository = repository;
    }

    public EventRepository getRepository() {
        return this.repository;
    }
}

