/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.audit.chart;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.ff4j.audit.Event;
import org.ff4j.audit.MutableHitCount;
import org.ff4j.audit.chart.AbstractChart;
import org.ff4j.audit.chart.Serie;
import org.ff4j.utils.JsonUtils;

public class TimeSeriesChart
extends AbstractChart {
    private static final long serialVersionUID = 4131401051473272099L;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HH:mm:ss");
    private List<String> timeSlots = new ArrayList<String>();
    private Map<String, Serie<Map<String, MutableHitCount>>> series = new HashMap<String, Serie<Map<String, MutableHitCount>>>();

    public TimeSeriesChart() {
    }

    public TimeSeriesChart(long from, long to, TimeUnit units) {
        this.initSlots(from, to, units);
    }

    public void initSlots(long from, long to, TimeUnit units) {
        long slotWitdh = 0L;
        switch (units) {
            case MINUTES: {
                slotWitdh = 60000L;
                this.sdf = new SimpleDateFormat("yyyyMMdd-HH:mm");
                break;
            }
            case HOURS: {
                slotWitdh = 3600000L;
                this.sdf = new SimpleDateFormat("yyyyMMdd-HH");
                break;
            }
            case DAYS: {
                slotWitdh = 86400000L;
                this.sdf = new SimpleDateFormat("yyyyMMdd");
                break;
            }
            default: {
                slotWitdh = 1000L;
                this.sdf = new SimpleDateFormat("yyyyMMdd-HH:mm:ss");
            }
        }
        int nbslot = new Long(1L + (to - from) / slotWitdh).intValue();
        for (int i = 0; i < nbslot; ++i) {
            long startSlotTime = from + slotWitdh * (long)i;
            String slotLabel = this.sdf.format(new Date(startSlotTime));
            this.getTimeSlots().add(slotLabel);
        }
    }

    public void addEvent(Event evt) {
        MutableHitCount mhc;
        if (!this.series.containsKey(evt.getName())) {
            this.createNewSerie(evt.getName());
        }
        String targetSlot = this.sdf.format(new Date(evt.getTimestamp()));
        Serie<Map<String, MutableHitCount>> targetSerie = this.series.get(evt.getName());
        if (targetSerie != null && (mhc = targetSerie.getValue().get(targetSlot)) != null) {
            mhc.inc();
        }
    }

    public void createNewSerie(String idSerie) {
        Serie newSerie = new Serie(idSerie);
        HashMap<String, MutableHitCount> val = new HashMap<String, MutableHitCount>();
        for (String slot : this.timeSlots) {
            val.put(slot, new MutableHitCount());
        }
        newSerie.setValue(val);
        this.series.put(idSerie, newSerie);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"slots\" : " + JsonUtils.collectionAsJson(this.timeSlots));
        StringBuilder sbNames = new StringBuilder("[");
        StringBuilder sbColors = new StringBuilder("[");
        StringBuilder sbValues = new StringBuilder("[");
        boolean first = true;
        for (Serie<Map<String, MutableHitCount>> serie : this.series.values()) {
            sbNames.append(first ? "" : ",");
            sbNames.append(JsonUtils.valueAsJson(serie.getLabel()));
            sbColors.append(first ? "" : ",");
            sbColors.append(JsonUtils.valueAsJson("#" + serie.getColor()));
            sbValues.append(first ? "" : ",");
            sbValues.append(serie.getValue().values().toString());
            first = false;
        }
        sbNames.append("]");
        sbColors.append("]");
        sbValues.append("]");
        sb.append(", \"serieNames\" : " + sbNames.toString());
        sb.append(", \"serieColors\" : " + sbColors.toString());
        sb.append(", \"serieValues\" : " + sbValues.toString());
        sb.append("}");
        return sb.toString();
    }

    public SimpleDateFormat getSdf() {
        return this.sdf;
    }

    public void setSdf(SimpleDateFormat sdf) {
        this.sdf = sdf;
    }

    public List<String> getTimeSlots() {
        return this.timeSlots;
    }

    public void setTimeSlots(List<String> timeSlots) {
        this.timeSlots = timeSlots;
    }

    public Map<String, Serie<Map<String, MutableHitCount>>> getSeries() {
        return this.series;
    }

    public void setSeries(Map<String, Serie<Map<String, MutableHitCount>>> series) {
        this.series = series;
    }
}

