/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.audit.proxy;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.ff4j.FF4j;
import org.ff4j.audit.EventBuilder;
import org.ff4j.property.Property;
import org.ff4j.property.store.PropertyStore;

public class PropertyStoreAuditProxy
implements PropertyStore {
    private PropertyStore target = null;
    private FF4j ff4j = null;

    public PropertyStoreAuditProxy(FF4j pFF4j, PropertyStore pTarget) {
        this.target = pTarget;
        this.ff4j = pFF4j;
    }

    @Override
    public <T> void createProperty(Property<T> prop) {
        long start = System.nanoTime();
        this.target.createProperty(prop);
        long duration = System.nanoTime() - start;
        this.publish(this.builder("create").property(prop.getName()).value(prop.asString()).duration(duration));
    }

    @Override
    public void updateProperty(String name, String newValue) {
        long start = System.nanoTime();
        this.target.updateProperty(name, newValue);
        long duration = System.nanoTime() - start;
        this.publish(this.builder("update").property(name).value(newValue).duration(duration));
    }

    @Override
    public <T> void updateProperty(Property<T> prop) {
        long start = System.nanoTime();
        this.target.updateProperty(prop);
        long duration = System.nanoTime() - start;
        this.publish(this.builder("update").property(prop.getName()).value(prop.asString()).duration(duration));
    }

    @Override
    public void deleteProperty(String name) {
        long start = System.nanoTime();
        this.target.deleteProperty(name);
        long duration = System.nanoTime() - start;
        this.publish(this.builder("delete").property(name).duration(duration));
    }

    @Override
    public boolean existProperty(String name) {
        return this.target.existProperty(name);
    }

    @Override
    public Property<?> readProperty(String name) {
        return this.target.readProperty(name);
    }

    @Override
    public Property<?> readProperty(String name, Property<?> defaultValue) {
        return this.target.readProperty(name, defaultValue);
    }

    @Override
    public Map<String, Property<?>> readAllProperties() {
        return this.target.readAllProperties();
    }

    @Override
    public Set<String> listPropertyNames() {
        return this.target.listPropertyNames();
    }

    @Override
    public boolean isEmpty() {
        return this.target.isEmpty();
    }

    @Override
    public void clear() {
        long start = System.nanoTime();
        this.target.clear();
        long duration = System.nanoTime() - start;
        this.publish(this.builder("clear").type("propertyStore").name(this.ff4j.getPropertiesStore().getClass().getName()).duration(duration));
    }

    @Override
    public void importProperties(Collection<Property<?>> properties) {
        if (properties != null) {
            for (Property<?> property : properties) {
                if (this.existProperty(property.getName())) {
                    this.deleteProperty(property.getName());
                }
                this.createProperty(property);
            }
        }
    }

    @Override
    public void createSchema() {
        this.target.createSchema();
        this.publish(this.builder("create-schema").feature("For Properties"));
    }

    private EventBuilder builder(String action) {
        return new EventBuilder(this.ff4j).type("property").action(action);
    }

    private void publish(EventBuilder eb) {
        this.ff4j.getEventPublisher().publish(eb.build());
    }

    public PropertyStore getTarget() {
        return this.target;
    }
}

