/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.audit.repository;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.ff4j.audit.Event;
import org.ff4j.audit.EventQueryDefinition;
import org.ff4j.audit.MutableHitCount;
import org.ff4j.audit.chart.BarChart;
import org.ff4j.audit.chart.PieChart;
import org.ff4j.audit.chart.Serie;
import org.ff4j.audit.repository.EventRepository;
import org.ff4j.utils.Util;

public abstract class AbstractEventRepository
implements EventRepository {
    protected static final SimpleDateFormat KDF = new SimpleDateFormat("yyyyMMdd");

    @Override
    public PieChart getFeatureUsagePieChart(EventQueryDefinition q) {
        return this.renderPieChartRainBow("Total Hit Counts" + this.getTitle(q), this.getFeatureUsageHitCount(q));
    }

    @Override
    public PieChart getHostPieChart(EventQueryDefinition q) {
        return this.renderPieChartGradient("HostNames " + this.getTitle(q), this.getHostHitCount(q), "00AB8B", "EEFFEE");
    }

    @Override
    public PieChart getSourcePieChart(EventQueryDefinition q) {
        return this.renderPieChartGradient("Sources " + this.getTitle(q), this.getSourceHitCount(q), "AB008B", "FFEEEE");
    }

    @Override
    public PieChart getUserPieChart(EventQueryDefinition q) {
        return this.renderPieChartGradient("Users " + this.getTitle(q), this.getUserHitCount(q), "008BAB", "EEEEFF");
    }

    protected PieChart renderPieChartGradient(String title, Map<String, MutableHitCount> hitRatio, String fromColor, String toColor) {
        return this.renderPieChart(title, hitRatio, Util.generateRGBGradient(fromColor, toColor, hitRatio.size()));
    }

    protected PieChart renderPieChartRainBow(String title, Map<String, MutableHitCount> hitRatio) {
        return this.renderPieChart(title, hitRatio, Util.generateHSVGradient("ee1100", "442299", hitRatio.size()));
    }

    private PieChart renderPieChart(String title, Map<String, MutableHitCount> hitRatio, List<String> colors) {
        PieChart pieChart = new PieChart(title);
        int idxColor = 0;
        for (String key : hitRatio.keySet()) {
            Serie<Integer> ps = new Serie<Integer>(key, hitRatio.get(key).get(), colors.get(idxColor));
            pieChart.getSectors().add(ps);
            ++idxColor;
        }
        return pieChart;
    }

    protected BarChart renderBarChartRainbow(String title, Map<String, MutableHitCount> hitRatio) {
        return this.renderBarChart(title, hitRatio, Util.generateHSVGradient("ee1100", "442299", hitRatio.size()));
    }

    protected BarChart renderBarChartGradient(String title, Map<String, MutableHitCount> hitRatio, String colorFrom, String colorTo) {
        return this.renderBarChart(title, hitRatio, Util.generateRGBGradient(colorFrom, colorTo, hitRatio.size()));
    }

    protected String getTitle(EventQueryDefinition q) {
        return " FROM <b>" + this.getKeyDate(q.getFrom()) + "</b> TO <b>" + this.getKeyDate(q.getTo()) + "</b>";
    }

    private BarChart renderBarChart(String title, Map<String, MutableHitCount> hitRatio, List<String> colors) {
        BarChart barChart = new BarChart(title);
        int idxColor = 0;
        for (String key : hitRatio.keySet()) {
            Serie<Integer> bar = new Serie<Integer>(key, new Double(hitRatio.get(key).get()).intValue(), colors.get(idxColor));
            barChart.getChartBars().add(bar);
            ++idxColor;
        }
        this.orderBarDecrecent(barChart);
        return barChart;
    }

    public void orderBarDecrecent(BarChart barChart) {
        Comparator<Serie<Integer>> c = new Comparator<Serie<Integer>>(){

            @Override
            public int compare(Serie<Integer> o1, Serie<Integer> o2) {
                return o1.getValue() - o2.getValue();
            }
        };
        Collections.sort(barChart.getChartBars(), c);
    }

    @Override
    public BarChart getFeatureUsageBarChart(EventQueryDefinition q) {
        return this.renderBarChartRainbow("HitCounts Distribution" + this.getTitle(q), this.getFeatureUsageHitCount(q));
    }

    @Override
    public BarChart getHostBarChart(EventQueryDefinition q) {
        return this.renderBarChartGradient("BarChart 'host' FROM " + this.getTitle(q), this.getHostHitCount(q), "00AB8B", "EEFFEE");
    }

    @Override
    public BarChart getSourceBarChart(EventQueryDefinition q) {
        return this.renderBarChartGradient("BarChart 'Source' FROM " + this.getTitle(q), this.getSourceHitCount(q), "AB008B", "FFEEEE");
    }

    @Override
    public BarChart getUserBarChart(EventQueryDefinition q) {
        return this.renderBarChartGradient("BarChart 'User' FROM " + this.getTitle(q), this.getUserHitCount(q), "008BAB", "EEEEFF");
    }

    @Override
    public int getFeatureUsageTotalHitCount(EventQueryDefinition q) {
        Map<String, MutableHitCount> hitRatio = this.getFeatureUsageHitCount(q);
        int total = 0;
        if (hitRatio != null) {
            for (MutableHitCount hc : hitRatio.values()) {
                total += hc.get();
            }
        }
        return total;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"type\":\"" + this.getClass().getCanonicalName() + "\"");
        EventQueryDefinition q = new EventQueryDefinition();
        sb.append(",\"todayHitsPieChart\": " + this.getFeatureUsagePieChart(q).toJson());
        sb.append(",\"todayHitsBarChart\": " + this.getFeatureUsageBarChart(q).toJson());
        this.getFeatureUsageHistory(q, TimeUnit.HOURS);
        sb.append(",\"todayTotalHitCount\":" + this.getFeatureUsageTotalHitCount(q));
        sb.append("}");
        return sb.toString();
    }

    protected boolean isEventInInterval(Event evt, long startTime, long endTime) {
        return evt.getTimestamp() >= startTime && evt.getTimestamp() <= endTime;
    }

    protected String getKeyDate(long time) {
        return KDF.format(new Date(time));
    }

    protected Set<String> getCandidateDays(long startTime, long endTime) {
        TreeSet<String> resultKeys = new TreeSet<String>();
        String endKey = this.getKeyDate(endTime);
        resultKeys.add(endKey);
        long time = startTime;
        while (!endKey.equals(this.getKeyDate(time))) {
            resultKeys.add(this.getKeyDate(time));
            time += 86400000L;
        }
        return resultKeys;
    }
}

