/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.cache;

import java.io.Serializable;

public final class InMemoryCacheEntry<T>
implements Serializable {
    private static final long serialVersionUID = -1444331517339058103L;
    public static final long DEFAULT_TTL = 3600L;
    public static final long TO_MILLIS = 1000L;
    private long timeToLive = 3600L;
    private final long insertedDate;
    private final T entry;

    public InMemoryCacheEntry(T entry) {
        this.entry = entry;
        this.insertedDate = System.currentTimeMillis();
    }

    public InMemoryCacheEntry(T entry, long timeToLive) {
        this.entry = entry;
        this.insertedDate = System.currentTimeMillis();
        this.timeToLive = timeToLive;
    }

    public boolean hasReachTimeToLive() {
        return System.currentTimeMillis() - this.getInsertedDate() >= 1000L * this.timeToLive;
    }

    public long getInsertedDate() {
        return this.insertedDate;
    }

    public T getEntry() {
        return this.entry;
    }
}

