/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.cache;

import java.io.Serializable;
import org.ff4j.cache.FF4JCacheManager;
import org.ff4j.core.Feature;
import org.ff4j.core.FeatureStore;
import org.ff4j.property.Property;
import org.ff4j.property.store.PropertyStore;

public class Store2CachePollingWorker
implements Runnable,
Serializable {
    private static final long serialVersionUID = 8252550757489651166L;
    private FeatureStore sourceFeatureStore;
    private PropertyStore sourcePropertyStore;
    private FF4JCacheManager cacheManager;

    public Store2CachePollingWorker(FeatureStore sf, PropertyStore sp, FF4JCacheManager cp) {
        this.sourceFeatureStore = sf;
        this.sourcePropertyStore = sp;
        this.cacheManager = cp;
    }

    @Override
    public void run() {
        if (this.sourceFeatureStore != null) {
            this.cacheManager.clearFeatures();
            for (Feature feature : this.sourceFeatureStore.readAll().values()) {
                this.cacheManager.putFeature(feature);
            }
        }
        if (this.sourcePropertyStore != null) {
            this.cacheManager.clearProperties();
            for (Property property : this.sourcePropertyStore.readAllProperties().values()) {
                this.cacheManager.putProperty(property);
            }
        }
    }
}

