/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.property.store;

import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.ff4j.conf.XmlConfig;
import org.ff4j.conf.XmlParser;
import org.ff4j.exception.PropertyAlreadyExistException;
import org.ff4j.exception.PropertyNotFoundException;
import org.ff4j.property.Property;
import org.ff4j.property.store.PropertyStore;
import org.ff4j.utils.Util;

public abstract class AbstractPropertyStore
implements PropertyStore {
    public Map<String, Property<?>> importPropertiesFromXmlFile(String xmlConfFile) {
        if (xmlConfFile == null || xmlConfFile.isEmpty()) {
            throw new IllegalArgumentException("Configuration filename cannot be null nor empty");
        }
        InputStream xmlIS = this.getClass().getClassLoader().getResourceAsStream(xmlConfFile);
        if (xmlIS == null) {
            throw new IllegalArgumentException("File " + xmlConfFile + " could not be read, please check path and rights");
        }
        XmlConfig conf = new XmlParser().parseConfigurationFile(xmlIS);
        Map<String, Property<?>> properties = conf.getProperties();
        for (Map.Entry<String, Property<?>> featureName : properties.entrySet()) {
            if (this.existProperty(featureName.getKey())) {
                this.deleteProperty(featureName.getKey());
            }
            this.createProperty(featureName.getValue());
        }
        return properties;
    }

    @Override
    public boolean isEmpty() {
        Set<String> pNames = this.listPropertyNames();
        return pNames == null || pNames.isEmpty();
    }

    public String toJson() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"type\":\"" + this.getClass().getCanonicalName() + "\"");
        Set<String> myProperties = this.readAllProperties().keySet();
        sb.append(",\"numberOfProperties\":" + myProperties.size());
        sb.append(",\"properties\":[");
        boolean first = true;
        for (String myProperty : myProperties) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append("\"" + myProperty + "\"");
        }
        sb.append("]}");
        return sb.toString();
    }

    protected void assertPropertyExist(String name) {
        Util.assertHasLength(name);
        if (!this.existProperty(name)) {
            throw new PropertyNotFoundException(name);
        }
    }

    protected void assertPropertyNotExist(String uid) {
        Util.assertHasLength(uid);
        if (this.existProperty(uid)) {
            throw new PropertyAlreadyExistException(uid);
        }
    }

    protected void assertPropertyNotNull(Property<?> property) {
        if (property == null) {
            throw new IllegalArgumentException("Property cannot be null nor empty");
        }
    }

    @Override
    public <T> void updateProperty(Property<T> prop) {
        Util.assertNotNull(prop);
        this.deleteProperty(prop.getName());
        this.createProperty(prop);
    }

    @Override
    public void updateProperty(String name, String newValue) {
        Property<?> p = this.readProperty(name);
        p.setValueFromString(newValue);
        this.updateProperty(p);
    }

    @Override
    public void importProperties(Collection<Property<?>> properties) {
        if (properties != null) {
            for (Property<?> property : properties) {
                if (this.existProperty(property.getName())) {
                    this.deleteProperty(property.getName());
                }
                this.createProperty(property);
            }
        }
    }

    @Override
    public Property<?> readProperty(String name, Property<?> defaultValue) {
        try {
            return this.readProperty(name);
        }
        catch (PropertyNotFoundException pnf) {
            return defaultValue;
        }
    }

    @Override
    public void createSchema() {
    }
}

