/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.property.store;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.ff4j.exception.PropertyAccessException;
import org.ff4j.exception.PropertyAlreadyExistException;
import org.ff4j.exception.PropertyNotFoundException;
import org.ff4j.property.Property;
import org.ff4j.property.store.AbstractPropertyStore;
import org.ff4j.property.store.JdbcPropertyMapper;
import org.ff4j.store.JdbcQueryBuilder;
import org.ff4j.utils.JdbcUtils;
import org.ff4j.utils.Util;

public class JdbcPropertyStore
extends AbstractPropertyStore {
    private DataSource dataSource;
    private JdbcQueryBuilder queryBuilder;
    private JdbcPropertyMapper JDBC_MAPPER = new JdbcPropertyMapper();

    public JdbcPropertyStore() {
    }

    public JdbcPropertyStore(DataSource jdbcDS) {
        this.dataSource = jdbcDS;
    }

    public JdbcPropertyStore(DataSource jdbcDS, String xmlConfFile) {
        this(jdbcDS);
        this.importPropertiesFromXmlFile(xmlConfFile);
    }

    @Override
    public void createSchema() {
        JdbcQueryBuilder qb;
        DataSource ds = this.getDataSource();
        if (!JdbcUtils.isTableExist(ds, (qb = this.getQueryBuilder()).getTableNameProperties())) {
            JdbcUtils.executeUpdate(ds, qb.sqlCreateTableProperties());
        }
    }

    @Override
    public boolean existProperty(String name) {
        boolean bl;
        Util.assertHasLength(name);
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection sqlConn = null;
        try {
            sqlConn = this.getDataSource().getConnection();
            ps = JdbcUtils.buildStatement(sqlConn, this.getQueryBuilder().existProperty(), name);
            rs = ps.executeQuery();
            rs.next();
            bl = 1 == rs.getInt(1);
        }
        catch (SQLException sqlEX) {
            try {
                throw new PropertyAccessException("Cannot check feature existence, error related to database", sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet(rs);
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn);
        return bl;
    }

    @Override
    public <T> void createProperty(Property<T> ap) {
        Util.assertNotNull(ap);
        Connection sqlConn = null;
        PreparedStatement ps = null;
        try {
            sqlConn = this.getDataSource().getConnection();
            if (this.existProperty(ap.getName())) {
                throw new PropertyAlreadyExistException(ap.getName());
            }
            ps = sqlConn.prepareStatement(this.getQueryBuilder().createProperty());
            ps.setString(1, ap.getName());
            ps.setString(2, ap.getType());
            ps.setString(3, ap.asString());
            ps.setString(4, ap.getDescription());
            if (ap.getFixedValues() != null && !ap.getFixedValues().isEmpty()) {
                String fixedValues = ap.getFixedValues().toString();
                ps.setString(5, fixedValues.substring(1, fixedValues.length() - 1));
            } else {
                ps.setString(5, null);
            }
            ps.executeUpdate();
        }
        catch (SQLException sqlEX) {
            try {
                throw new PropertyAccessException("Cannot update properties database, SQL ERROR", sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn);
    }

    @Override
    public Property<?> readProperty(String name) {
        Property<?> property;
        Util.assertHasLength(name);
        Connection sqlConn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            sqlConn = this.getDataSource().getConnection();
            if (!this.existProperty(name)) {
                throw new PropertyNotFoundException(name);
            }
            ps = JdbcUtils.buildStatement(sqlConn, this.getQueryBuilder().getProperty(), name);
            rs = ps.executeQuery();
            rs.next();
            property = this.JDBC_MAPPER.map(rs);
        }
        catch (SQLException sqlEX) {
            try {
                throw new PropertyAccessException("Cannot check property existence, error related to database", sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet(rs);
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn);
        return property;
    }

    @Override
    public void updateProperty(String name, String newValue) {
        Util.assertHasLength(name);
        Connection sqlConn = null;
        PreparedStatement ps = null;
        try {
            sqlConn = this.getDataSource().getConnection();
            Property<?> ab = this.readProperty(name);
            ab.fromString(newValue);
            ps = JdbcUtils.buildStatement(sqlConn, this.getQueryBuilder().updateProperty(), newValue, name);
            ps.executeUpdate();
        }
        catch (SQLException sqlEX) {
            try {
                throw new PropertyAccessException("Cannot update property database, SQL ERROR", sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn);
    }

    @Override
    public <T> void updateProperty(Property<T> prop) {
        if (prop == null || prop.getName() == null) {
            throw new IllegalArgumentException("Cannot update property, please provide property name");
        }
        this.deleteProperty(prop.getName());
        this.createProperty(prop);
    }

    @Override
    public void deleteProperty(String name) {
        Util.assertHasLength(name);
        Connection sqlConn = null;
        PreparedStatement ps = null;
        try {
            sqlConn = this.getDataSource().getConnection();
            if (!this.existProperty(name)) {
                throw new PropertyNotFoundException(name);
            }
            ps = JdbcUtils.buildStatement(sqlConn, this.getQueryBuilder().deleteProperty(), name);
            ps.executeUpdate();
        }
        catch (SQLException sqlEX) {
            try {
                throw new PropertyAccessException("Cannot delete property database, SQL ERROR", sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn);
    }

    @Override
    public Map<String, Property<?>> readAllProperties() {
        LinkedHashMap properties = new LinkedHashMap();
        Connection sqlConn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            sqlConn = this.getDataSource().getConnection();
            ps = JdbcUtils.buildStatement(sqlConn, this.getQueryBuilder().getAllProperties(), new String[0]);
            rs = ps.executeQuery();
            while (rs.next()) {
                Property<?> ap = this.JDBC_MAPPER.map(rs);
                properties.put(ap.getName(), ap);
            }
        }
        catch (SQLException sqlEX) {
            try {
                throw new PropertyAccessException("Cannot read properties within database, SQL ERROR", sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet(rs);
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn);
        return properties;
    }

    @Override
    public Set<String> listPropertyNames() {
        HashSet<String> propertyNames = new HashSet<String>();
        PreparedStatement ps = null;
        Connection sqlConn = null;
        ResultSet rs = null;
        try {
            sqlConn = this.getDataSource().getConnection();
            ps = JdbcUtils.buildStatement(sqlConn, this.getQueryBuilder().getAllPropertiesNames(), new String[0]);
            rs = ps.executeQuery();
            while (rs.next()) {
                propertyNames.add(rs.getString("PROPERTY_ID"));
            }
        }
        catch (SQLException sqlEX) {
            try {
                throw new PropertyAccessException("Cannot read properties within database, SQL ERROR", sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet(rs);
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn);
        return propertyNames;
    }

    @Override
    public void clear() {
        PreparedStatement ps = null;
        Connection sqlConn = null;
        try {
            sqlConn = this.getDataSource().getConnection();
            ps = JdbcUtils.buildStatement(sqlConn, this.getQueryBuilder().deleteAllProperties(), new String[0]);
            ps.executeUpdate();
        }
        catch (SQLException sqlEX) {
            try {
                throw new PropertyAccessException("Cannot clear properties table, SQL ERROR", sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public JdbcQueryBuilder getQueryBuilder() {
        if (this.queryBuilder == null) {
            this.queryBuilder = new JdbcQueryBuilder();
        }
        return this.queryBuilder;
    }

    public void setQueryBuilder(JdbcQueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }
}

