/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.property.util;

import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ff4j.property.Property;
import org.ff4j.property.PropertyBigDecimal;
import org.ff4j.property.PropertyBigInteger;
import org.ff4j.property.PropertyBoolean;
import org.ff4j.property.PropertyByte;
import org.ff4j.property.PropertyCalendar;
import org.ff4j.property.PropertyDate;
import org.ff4j.property.PropertyDouble;
import org.ff4j.property.PropertyFloat;
import org.ff4j.property.PropertyInt;
import org.ff4j.property.PropertyLogLevel;
import org.ff4j.property.PropertyLong;
import org.ff4j.property.PropertyShort;
import org.ff4j.property.PropertyString;
import org.ff4j.property.util.PropertyJsonBean;
import org.ff4j.utils.Util;

public class PropertyFactory {
    private static Map<Class<?>, Class<?>> validPropertyPrimitives = new HashMap();

    public static Property<?> createProperty(String pName, Object value) {
        Util.assertHasLength(pName);
        Util.assertNotNull(value);
        if (validPropertyPrimitives.containsKey(value.getClass())) {
            return PropertyFactory.createProperty(pName, validPropertyPrimitives.get(value.getClass()).getName(), String.valueOf(value), null, null);
        }
        if (value instanceof Date) {
            return PropertyFactory.createProperty(pName, PropertyDate.class.getName(), PropertyDate.SDF.format(value), null, null);
        }
        if (value instanceof Calendar) {
            Date valueDate = ((Calendar)value).getTime();
            return PropertyFactory.createProperty(pName, PropertyCalendar.class.getName(), PropertyCalendar.SDF.format(valueDate), null, null);
        }
        if (value instanceof Property) {
            return (Property)value;
        }
        if (value.getClass().isArray() || Util.isCollection(value)) {
            return PropertyFactory.createProperty(pName, PropertyString.class.getName(), Util.join(Util.asCollection(value), ","), null, null);
        }
        throw new IllegalArgumentException("Cannot create property with input type " + value.getClass() + value.toString());
    }

    public static Property<?> createProperty(String pName, String pType, String pValue) {
        return PropertyFactory.createProperty(pName, pType, pValue, null, null);
    }

    public static Property<?> createProperty(PropertyJsonBean pgb) {
        if (pgb == null) {
            return null;
        }
        return PropertyFactory.createProperty(pgb.getName(), pgb.getType(), pgb.getValue(), pgb.getDescription(), pgb.getFixedValues());
    }

    public static Property<?> createProperty(String pName, String pType, String pValue, String desc, Set<String> fixedValues) {
        Util.assertNotNull(pName, new Object[0]);
        Util.assertNotNull(pType, new Object[0]);
        Property ap = null;
        try {
            Constructor<?> constr = Class.forName(pType).getConstructor(String.class, String.class);
            ap = (Property)constr.newInstance(pName, pValue);
            ap.setDescription(desc);
            if (fixedValues != null && !fixedValues.isEmpty()) {
                for (String v : fixedValues) {
                    ap.add2FixedValueFromString(v.trim());
                }
                if (!ap.getFixedValues().contains(ap.getValue())) {
                    throw new IllegalArgumentException("Cannot create property <" + ap.getName() + "> invalid value <" + ap.getValue() + "> expected one of " + ap.getFixedValues());
                }
            }
            return ap;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot instantiate '" + pType + "' check default constructor : " + e.getMessage(), e);
        }
    }

    static {
        validPropertyPrimitives.put(Byte.class, PropertyByte.class);
        validPropertyPrimitives.put(Short.class, PropertyShort.class);
        validPropertyPrimitives.put(Integer.class, PropertyInt.class);
        validPropertyPrimitives.put(Long.class, PropertyLong.class);
        validPropertyPrimitives.put(Double.class, PropertyDouble.class);
        validPropertyPrimitives.put(Boolean.class, PropertyBoolean.class);
        validPropertyPrimitives.put(Float.class, PropertyFloat.class);
        validPropertyPrimitives.put(BigInteger.class, PropertyBigInteger.class);
        validPropertyPrimitives.put(BigDecimal.class, PropertyBigDecimal.class);
        validPropertyPrimitives.put(PropertyLogLevel.LogLevel.class, PropertyLogLevel.class);
        validPropertyPrimitives.put(String.class, PropertyString.class);
    }
}

