/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.property.util;

import java.io.Serializable;
import java.util.HashSet;
import org.ff4j.property.BasePropertyBean;
import org.ff4j.property.Property;
import org.ff4j.property.util.PropertyFactory;

public class PropertyJsonBean
extends BasePropertyBean
implements Serializable {
    private static final long serialVersionUID = 7249710480883717637L;

    public PropertyJsonBean() {
    }

    public PropertyJsonBean(Property<?> property) {
        if (property != null) {
            this.name = property.getName();
            this.description = property.getDescription();
            this.type = property.getType();
            this.value = property.asString();
            if (property.getFixedValues() != null) {
                this.fixedValues = new HashSet();
                for (Object fv : property.getFixedValues()) {
                    this.fixedValues.add(fv.toString());
                }
            }
        }
    }

    public PropertyJsonBean addFixedValue(String value) {
        if (this.fixedValues == null) {
            this.fixedValues = new HashSet();
        }
        this.fixedValues.add(value);
        return this;
    }

    public Property<?> asProperty() {
        return PropertyFactory.createProperty(this);
    }

    public String toString() {
        return this.asJson();
    }

    public String asJson() {
        StringBuilder jsonExpression = new StringBuilder("{");
        jsonExpression.append("\"name\":\"" + this.name + "\"");
        jsonExpression.append(",\"description\":");
        jsonExpression.append(null == this.description ? "null" : "\"" + this.description + "\"");
        jsonExpression.append(",\"type\":\"" + this.type + "\"");
        jsonExpression.append(",\"value\":");
        jsonExpression.append(null == this.value ? "null" : "\"" + this.value + "\"");
        if (this.fixedValues == null) {
            jsonExpression.append(",\"fixedValues\":null");
        } else {
            jsonExpression.append(",\"fixedValues\":[");
            boolean first = true;
            for (String auth : this.fixedValues) {
                jsonExpression.append(first ? "" : ",");
                jsonExpression.append("\"" + auth + "\"");
                first = false;
            }
            jsonExpression.append("]");
        }
        jsonExpression.append("}");
        return jsonExpression.toString();
    }
}

