/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.strategy;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ff4j.core.FeatureStore;
import org.ff4j.core.FlippingExecutionContext;
import org.ff4j.strategy.AbstractFlipStrategy;
import org.ff4j.utils.IOUtil;

public class ServerFilterStrategy
extends AbstractFlipStrategy {
    private static final String PARAM_SERVERLIST = "grantedServers";
    public static final String SERVER_HOSTNAME = "serverHostName";
    private static final String SPLITTER = ",";
    private final Set<String> setOfTargetServer = new HashSet<String>();
    private String rawServerList = null;

    public ServerFilterStrategy() {
    }

    public ServerFilterStrategy(String targetServers) {
        this.rawServerList = targetServers;
        this.getInitParams().put(PARAM_SERVERLIST, targetServers);
        for (String server : this.rawServerList.split(SPLITTER)) {
            this.setOfTargetServer.add(server.trim());
        }
    }

    @Override
    public void init(String featureName, Map<String, String> initParams) {
        super.init(featureName, initParams);
        if (initParams != null && initParams.containsKey(PARAM_SERVERLIST)) {
            this.rawServerList = initParams.get(PARAM_SERVERLIST);
        }
        this.setOfTargetServer.addAll(Arrays.asList(this.rawServerList.split(SPLITTER)));
    }

    @Override
    public boolean evaluate(String featureName, FeatureStore store, FlippingExecutionContext ctx) {
        if (null != ctx && ctx.containsKey(SERVER_HOSTNAME)) {
            return this.setOfTargetServer.contains(ctx.getString(SERVER_HOSTNAME));
        }
        return this.setOfTargetServer.contains(IOUtil.resolveHostName());
    }
}

