/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.strategy.time;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ff4j.core.FeatureStore;
import org.ff4j.core.FlippingExecutionContext;
import org.ff4j.strategy.AbstractFlipStrategy;
import org.ff4j.strategy.time.HourInterval;

public class OfficeHourStrategy
extends AbstractFlipStrategy {
    private static final DateFormat SDF_DATE = new SimpleDateFormat("yyyy-MM-dd");
    private static final String MONDAY = "monday";
    private static final String TUESDAY = "tuesday";
    private static final String WEDNESDAY = "wednesday";
    private static final String THURSDAY = "thursday";
    private static final String FRIDAY = "friday";
    private static final String SATURDAY = "saturday";
    private static final String SUNDAY = "sunday";
    private static final String PUBLICHOLIDAY = "publicHolidays";
    private static final String SPECIAL_OPENINGS = "specialOpenings";
    public static final String OVERRIDE_DATE = "overridedDate";
    private Map<Integer, List<HourInterval>> weekTimeTable = new HashMap<Integer, List<HourInterval>>();
    private Map<String, List<HourInterval>> specialTimeTable = new HashMap<String, List<HourInterval>>();
    private List<String> publicHolidays = new ArrayList<String>();

    @Override
    public void init(String featureName, Map<String, String> initParam) {
        String[] days;
        super.init(featureName, initParam);
        this.weekTimeTable.put(2, this.parseIntervalsExpression(initParam.get(MONDAY)));
        this.weekTimeTable.put(3, this.parseIntervalsExpression(initParam.get(TUESDAY)));
        this.weekTimeTable.put(4, this.parseIntervalsExpression(initParam.get(WEDNESDAY)));
        this.weekTimeTable.put(5, this.parseIntervalsExpression(initParam.get(THURSDAY)));
        this.weekTimeTable.put(6, this.parseIntervalsExpression(initParam.get(FRIDAY)));
        this.weekTimeTable.put(7, this.parseIntervalsExpression(initParam.get(SATURDAY)));
        this.weekTimeTable.put(1, this.parseIntervalsExpression(initParam.get(SUNDAY)));
        if (initParam.containsKey(PUBLICHOLIDAY)) {
            for (String day : days = initParam.get(PUBLICHOLIDAY).split(",")) {
                try {
                    Calendar c = Calendar.getInstance();
                    c.setTime(SDF_DATE.parse(day.trim()));
                    c.set(14, 0);
                    c.set(13, 0);
                    c.set(12, 0);
                    c.set(11, 0);
                    this.publicHolidays.add(SDF_DATE.format(c.getTime()));
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("Invalid Syntax for <" + day + "> expected 'yyyy-MM-dd'", e);
                }
            }
        }
        if (initParam.containsKey(SPECIAL_OPENINGS)) {
            for (String day : days = initParam.get(SPECIAL_OPENINGS).split(";")) {
                String[] partDay = day.split("@");
                if (partDay.length != 2) {
                    throw new IllegalArgumentException("Invalid Syntax");
                }
                String dateExpression = partDay[1].trim();
                try {
                    SDF_DATE.parse(dateExpression);
                    String inter = partDay[0].trim();
                    String extractIntervals = inter.substring(1, inter.length() - 1);
                    this.specialTimeTable.put(dateExpression, this.parseIntervalsExpression(extractIntervals));
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("Invalid Syntax for '" + dateExpression + "' expected 'yyyy-MM-dd'", e);
                }
            }
        }
    }

    public List<HourInterval> parseIntervalsExpression(String expression) {
        ArrayList<HourInterval> lhi = new ArrayList<HourInterval>();
        if (expression != null && !"".equals(expression)) {
            String[] chunks;
            for (String chunk : chunks = expression.split(",")) {
                lhi.add(new HourInterval(chunk));
            }
        }
        return lhi;
    }

    public boolean matches(Calendar cal, List<HourInterval> listOfHI) {
        if (listOfHI == null) {
            return false;
        }
        boolean found = false;
        for (int idx = 0; !found && idx < listOfHI.size(); ++idx) {
            found = listOfHI.get(idx).matches(cal);
        }
        return found;
    }

    @Override
    public boolean evaluate(String featureName, FeatureStore store, FlippingExecutionContext executionContext) {
        String currentDate;
        Calendar now = Calendar.getInstance();
        if (executionContext != null && executionContext.containsKey(OVERRIDE_DATE)) {
            now = (Calendar)executionContext.getValue(OVERRIDE_DATE, false);
        }
        if (this.specialTimeTable.containsKey(currentDate = SDF_DATE.format(now.getTime()))) {
            return this.matches(now, this.specialTimeTable.get(currentDate));
        }
        if (this.publicHolidays.contains(currentDate)) {
            return false;
        }
        return this.matches(now, this.weekTimeTable.get(now.get(7)));
    }
}

