/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.ff4j.FF4j;
import org.ff4j.core.Feature;
import org.ff4j.property.Property;
import org.ff4j.utils.Util;

public class GeneratorUtils {
    private static final String ENCODING = "UTF-8";

    private GeneratorUtils() {
    }

    public static String generateInterfaceConstantsSource(FF4j ff4j) {
        Util.assertNotNull(ff4j);
        StringBuilder sb = new StringBuilder();
        sb.append("/**\r\n * Constants for ff4j features and properties.");
        sb.append("\r\n * Generated on : " + new SimpleDateFormat("yyyy-MM-DD HH:mm").format(new Date()));
        sb.append("\r\n *");
        sb.append("\r\n * @author FF4J Generator Engine");
        sb.append("\r\n */");
        sb.append("\r\npublic interface FF4jConstants {");
        sb.append("\r\n");
        sb.append("\r\n   // -------------------------");
        sb.append("\r\n   //  Features ");
        sb.append("\r\n   // -------------------------");
        sb.append("\r\n");
        for (Map.Entry<String, Feature> entry : ff4j.getFeatureStore().readAll().entrySet()) {
            sb.append("\r\n   /* Feature '" + entry.getKey() + "' : '" + entry.getValue().getDescription() + "' */");
            sb.append("\r\n   String FEATURE_" + entry.getKey().replaceAll(" ", "_").toUpperCase() + " = \"" + entry.getKey() + "\";");
            sb.append("\r\n");
        }
        sb.append("\r\n   // -------------------------");
        sb.append("\r\n   //  Groups ");
        sb.append("\r\n   // -------------------------");
        sb.append("\r\n");
        for (String string : ff4j.getFeatureStore().readAllGroups()) {
            sb.append("\r\n   /* Group '" + string + "' */");
            sb.append("\r\n   String FEATURE_GROUP_" + string.replaceAll(" ", "_").toUpperCase() + " = \"" + string + "\";");
            sb.append("\r\n");
        }
        sb.append("\r\n   // -------------------------");
        sb.append("\r\n   //  Properties ");
        sb.append("\r\n   // -------------------------");
        sb.append("\r\n");
        for (Map.Entry entry : ff4j.getPropertiesStore().readAllProperties().entrySet()) {
            sb.append("\r\n   /* Property '" + (String)entry.getKey() + "' : '" + ((Property)entry.getValue()).getDescription() + "' */");
            sb.append("\r\n   String PROPERTY_" + ((String)entry.getKey()).replaceAll(" ", "_").toUpperCase() + " = \"" + (String)entry.getKey() + "\";");
            sb.append("\r\n");
        }
        sb.append("\r\n}");
        return sb.toString();
    }

    public static InputStream exportInterfaceConstants(FF4j ff4j) throws IOException {
        return new ByteArrayInputStream(GeneratorUtils.generateInterfaceConstantsSource(ff4j).getBytes(ENCODING));
    }

    public static void generateInterfaceConstantFile(FF4j ff4j, File folder) throws IOException {
        Util.assertNotNull(folder);
        File outFile = new File(folder.getAbsolutePath() + File.separator + "FF4jConstants.java");
        FileWriter out = new FileWriter(outFile);
        out.write(GeneratorUtils.generateInterfaceConstantsSource(ff4j));
        out.close();
    }
}

