/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.utils;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.ff4j.exception.FeatureAccessException;
import org.ff4j.utils.Util;

public class JdbcUtils {
    private JdbcUtils() {
    }

    public static boolean isTableExist(DataSource ds, String tableName) {
        boolean bl;
        Util.assertHasLength(tableName);
        Connection sqlConn = null;
        ResultSet rs = null;
        try {
            sqlConn = ds.getConnection();
            DatabaseMetaData dbmd = sqlConn.getMetaData();
            rs = dbmd.getTables(null, null, tableName, new String[]{"TABLE"});
            bl = rs.next();
        }
        catch (SQLException sqlEX) {
            try {
                throw new FeatureAccessException("Cannot check table existence", sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet(rs);
        JdbcUtils.closeConnection(sqlConn);
        return bl;
    }

    public static void executeUpdate(DataSource ds, String sqlQuery) {
        Util.assertHasLength(sqlQuery);
        Connection sqlConn = null;
        Statement sqlStmt = null;
        try {
            sqlConn = ds.getConnection();
            sqlStmt = sqlConn.createStatement();
            sqlStmt.executeUpdate(sqlQuery);
        }
        catch (SQLException sqlEX) {
            try {
                JdbcUtils.rollback(sqlConn);
                throw new FeatureAccessException("Cannot execute SQL " + sqlQuery, sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(sqlStmt);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(sqlStmt);
        JdbcUtils.closeConnection(sqlConn);
    }

    public static PreparedStatement buildStatement(Connection sqlConn, String query, String ... params) throws SQLException {
        PreparedStatement ps = sqlConn.prepareStatement(query);
        if (params != null && params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
        }
        return ps;
    }

    public static void closeResultSet(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            throw new FeatureAccessException("An error occur when closing resultset", e);
        }
    }

    public static void closeStatement(PreparedStatement ps) {
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            throw new FeatureAccessException("An error occur when closing statement", e);
        }
    }

    public static void closeStatement(Statement ps) {
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            throw new FeatureAccessException("An error occur when closing statement", e);
        }
    }

    public static void closeConnection(Connection sqlConnection, Boolean previousAutoCommit) {
        try {
            if (sqlConnection != null && !sqlConnection.isClosed()) {
                if (previousAutoCommit != null) {
                    sqlConnection.setAutoCommit(previousAutoCommit);
                }
                sqlConnection.close();
            }
        }
        catch (SQLException e) {
            throw new FeatureAccessException("An error occur when closing statement", e);
        }
    }

    public static void closeConnection(Connection sqlConnection) {
        JdbcUtils.closeConnection(sqlConnection, null);
    }

    public static void rollback(Connection sqlConn) {
        try {
            if (sqlConn != null && !sqlConn.isClosed()) {
                sqlConn.rollback();
            }
        }
        catch (SQLException e) {
            throw new FeatureAccessException("Cannot rollback database, SQL ERROR", e);
        }
    }
}

