/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ff4j.FF4j;
import org.ff4j.web.FF4jProvider;

public class ApiConfig
implements FF4jProvider {
    private FF4j ff4j;
    private boolean authenticate = false;
    private boolean autorize = false;
    private boolean log = false;
    private boolean documentation = true;
    private String version = this.getClass().getPackage().getImplementationVersion();
    private Map<String, String> users = new HashMap<String, String>();
    private Set<String> apiKeys = new HashSet<String>();
    private Map<String, Set<String>> permissions = new HashMap<String, Set<String>>();
    private String host = "localhost";
    private int port = 8282;
    private String webContext = "ff4j-demo";

    public ApiConfig() {
        this.version = this.getClass().getPackage().getImplementationVersion();
    }

    public ApiConfig(FF4j ff) {
        this();
        this.ff4j = ff;
    }

    public ApiConfig createUser(String userName, String password, boolean read, boolean write, Set<String> usrPerm) {
        this.users.put(userName, password);
        HashSet<String> tmpPerm = new HashSet<String>();
        if (read) {
            tmpPerm.add("READ");
        }
        if (write) {
            tmpPerm.add("WRITE");
        }
        if (usrPerm != null) {
            tmpPerm.addAll(usrPerm);
        }
        this.permissions.put(userName, tmpPerm);
        return this;
    }

    public ApiConfig createApiKey(String apiKey, boolean read, boolean write, Set<String> usrPerm) {
        this.apiKeys.add(apiKey);
        HashSet<String> tmpPerm = new HashSet<String>();
        if (read) {
            tmpPerm.add("READ");
        }
        if (write) {
            tmpPerm.add("WRITE");
        }
        if (usrPerm != null) {
            tmpPerm.addAll(usrPerm);
        }
        this.permissions.put(apiKey, tmpPerm);
        return this;
    }

    @Override
    public FF4j getFF4j() {
        return this.ff4j;
    }

    public void setFF4j(FF4j fF4j) {
        this.ff4j = fF4j;
    }

    public Map<String, String> getUsers() {
        return this.users;
    }

    public void setUsers(Map<String, String> users) {
        this.users = users;
    }

    public Set<String> getApiKeys() {
        return this.apiKeys;
    }

    public void setApiKeys(Set<String> apiKeys) {
        this.apiKeys = apiKeys;
    }

    public Map<String, Set<String>> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Map<String, Set<String>> permissions) {
        this.permissions = permissions;
    }

    public String getContextPath() {
        return "http://" + this.getHost() + ":" + this.getPort() + "/" + this.getWebContext() + "/api";
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getWebContext() {
        return this.webContext;
    }

    public void setWebContext(String webContext) {
        this.webContext = webContext;
    }

    public boolean isAuthenticate() {
        return this.authenticate;
    }

    public void setAuthenticate(boolean authenticate) {
        this.authenticate = authenticate;
    }

    public boolean isAutorize() {
        return this.autorize;
    }

    public void setAutorize(boolean autorize) {
        this.autorize = autorize;
    }

    public boolean isLog() {
        return this.log;
    }

    public void setLog(boolean log) {
        this.log = log;
    }

    public boolean isDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(boolean documentation) {
        this.documentation = documentation;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

