/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.property;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.ff4j.property.Property;

public class PropertyInstant
extends Property<Instant> {
    private static final long serialVersionUID = -620523134883483837L;
    protected static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    protected ZoneOffset zone = ZoneOffset.UTC;

    public PropertyInstant(String name) {
        super(name);
    }

    public PropertyInstant(String uid, String value) {
        super(uid, value);
    }

    public PropertyInstant(String uid, Instant date) {
        super(uid, date, new Instant[0]);
    }

    public LocalDateTime toLocalDateTime() {
        return LocalDateTime.ofInstant((Instant)this.value, this.zone);
    }

    @Override
    public String asString() {
        if (this.value == null) {
            return null;
        }
        return this.toLocalDateTime().format(FORMATTER);
    }

    @Override
    public Instant fromString(String v) {
        return LocalDateTime.parse(v, FORMATTER).toInstant(this.zone);
    }

    public ZoneOffset getZone() {
        return this.zone;
    }

    public void setZone(ZoneOffset zone) {
        this.zone = zone;
    }
}

