/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.store;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.ff4j.core.Feature;
import org.ff4j.exception.FeatureAccessException;
import org.ff4j.exception.FeatureAlreadyExistException;
import org.ff4j.property.Property;
import org.ff4j.property.store.JdbcPropertyMapper;
import org.ff4j.store.AbstractFeatureStore;
import org.ff4j.store.JdbcFeatureMapper;
import org.ff4j.store.JdbcQueryBuilder;
import org.ff4j.utils.JdbcUtils;
import org.ff4j.utils.MappingUtil;
import org.ff4j.utils.Util;

public class JdbcFeatureStore
extends AbstractFeatureStore {
    public static final String CANNOT_CHECK_FEATURE_EXISTENCE_ERROR_RELATED_TO_DATABASE = "Cannot check feature existence, error related to database";
    public static final String CANNOT_UPDATE_FEATURES_DATABASE_SQL_ERROR = "Cannot update features database, SQL ERROR";
    private DataSource dataSource;
    private JdbcQueryBuilder queryBuilder;
    private JdbcPropertyMapper JDBC_PROPERTY_MAPPER = new JdbcPropertyMapper();
    private JdbcFeatureMapper JDBC_FEATURE_MAPPER = new JdbcFeatureMapper();

    public JdbcFeatureStore() {
    }

    public JdbcFeatureStore(DataSource jdbcDS) {
        this.dataSource = jdbcDS;
    }

    public JdbcFeatureStore(DataSource jdbcDS, String xmlConfFile) {
        this(jdbcDS);
        this.importFeaturesFromXmlFile(xmlConfFile);
    }

    @Override
    public void createSchema() {
        JdbcQueryBuilder qb;
        DataSource ds = this.getDataSource();
        if (!JdbcUtils.isTableExist(ds, (qb = this.getQueryBuilder()).getTableNameFeatures())) {
            JdbcUtils.executeUpdate(ds, qb.sqlCreateTableFeatures());
        }
        if (!JdbcUtils.isTableExist(ds, qb.getTableNameCustomProperties())) {
            JdbcUtils.executeUpdate(ds, qb.sqlCreateTableCustomProperties());
        }
        if (!JdbcUtils.isTableExist(ds, qb.getTableNameRoles())) {
            JdbcUtils.executeUpdate(ds, qb.sqlCreateTableRoles());
        }
    }

    @Override
    public void enable(String uid) {
        this.assertFeatureExist(uid);
        this.update(this.getQueryBuilder().enableFeature(), uid);
    }

    @Override
    public void disable(String uid) {
        this.assertFeatureExist(uid);
        this.update(this.getQueryBuilder().disableFeature(), uid);
    }

    @Override
    public boolean exist(String uid) {
        boolean bl;
        Util.assertHasLength(uid);
        Connection sqlConn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            sqlConn = this.getDataSource().getConnection();
            ps = JdbcUtils.buildStatement(sqlConn, this.getQueryBuilder().existFeature(), uid);
            rs = ps.executeQuery();
            rs.next();
            bl = 1 == rs.getInt(1);
        }
        catch (SQLException sqlEX) {
            try {
                throw new FeatureAccessException(CANNOT_CHECK_FEATURE_EXISTENCE_ERROR_RELATED_TO_DATABASE, sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet(rs);
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn);
        return bl;
    }

    @Override
    public Feature read(String uid) {
        Feature feature;
        this.assertFeatureExist(uid);
        Connection sqlConn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            sqlConn = this.getDataSource().getConnection();
            ps = sqlConn.prepareStatement(this.getQueryBuilder().getFeature());
            ps.setString(1, uid);
            rs = ps.executeQuery();
            rs.next();
            Feature f = this.JDBC_FEATURE_MAPPER.mapFeature(rs);
            JdbcUtils.closeResultSet(rs);
            rs = null;
            JdbcUtils.closeStatement(ps);
            ps = null;
            ps = sqlConn.prepareStatement(this.getQueryBuilder().getRoles());
            ps.setString(1, uid);
            rs = ps.executeQuery();
            while (rs.next()) {
                f.getPermissions().add(rs.getString("ROLE_NAME"));
            }
            JdbcUtils.closeResultSet(rs);
            rs = null;
            JdbcUtils.closeStatement(ps);
            ps = null;
            ps = sqlConn.prepareStatement(this.getQueryBuilder().getFeatureProperties());
            ps.setString(1, uid);
            rs = ps.executeQuery();
            while (rs.next()) {
                f.addProperty(this.JDBC_PROPERTY_MAPPER.map(rs));
            }
            feature = f;
        }
        catch (SQLException sqlEX) {
            try {
                throw new FeatureAccessException(CANNOT_CHECK_FEATURE_EXISTENCE_ERROR_RELATED_TO_DATABASE, sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet(rs);
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn);
        return feature;
    }

    @Override
    public void create(Feature fp) {
        this.assertFeatureNotNull(fp);
        Connection sqlConn = null;
        PreparedStatement ps = null;
        Boolean previousAutoCommit = null;
        try {
            sqlConn = this.getDataSource().getConnection();
            if (this.exist(fp.getUid())) {
                throw new FeatureAlreadyExistException(fp.getUid());
            }
            previousAutoCommit = sqlConn.getAutoCommit();
            sqlConn.setAutoCommit(false);
            ps = sqlConn.prepareStatement(this.getQueryBuilder().createFeature());
            ps.setString(1, fp.getUid());
            ps.setInt(2, fp.isEnable() ? 1 : 0);
            ps.setString(3, fp.getDescription());
            String strategyColumn = null;
            String expressionColumn = null;
            if (fp.getFlippingStrategy() != null) {
                strategyColumn = fp.getFlippingStrategy().getClass().getName();
                expressionColumn = MappingUtil.fromMap(fp.getFlippingStrategy().getInitParams());
            }
            ps.setString(4, strategyColumn);
            ps.setString(5, expressionColumn);
            ps.setString(6, fp.getGroup());
            ps.executeUpdate();
            JdbcUtils.closeStatement(ps);
            ps = null;
            for (String string : fp.getPermissions()) {
                ps = sqlConn.prepareStatement(this.getQueryBuilder().addRoleToFeature());
                ps.setString(1, fp.getUid());
                ps.setString(2, string);
                ps.executeUpdate();
                JdbcUtils.closeStatement(ps);
                ps = null;
            }
            if (fp.getCustomProperties() != null && !fp.getCustomProperties().isEmpty()) {
                for (Property property : fp.getCustomProperties().values()) {
                    ps = this.createCustomProperty(sqlConn, fp.getUid(), property);
                    JdbcUtils.closeStatement(ps);
                    ps = null;
                }
            }
            sqlConn.commit();
        }
        catch (SQLException sqlEX) {
            try {
                JdbcUtils.rollback(sqlConn);
                throw new FeatureAccessException(CANNOT_UPDATE_FEATURES_DATABASE_SQL_ERROR, sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn, previousAutoCommit);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn, previousAutoCommit);
    }

    @Override
    public void delete(String uid) {
        this.assertFeatureExist(uid);
        Connection sqlConn = null;
        PreparedStatement ps = null;
        Boolean previousAutoCommit = null;
        try {
            sqlConn = this.getDataSource().getConnection();
            previousAutoCommit = sqlConn.getAutoCommit();
            sqlConn.setAutoCommit(false);
            Feature fp = this.read(uid);
            if (fp.getCustomProperties() != null) {
                for (String property : fp.getCustomProperties().keySet()) {
                    ps = sqlConn.prepareStatement(this.getQueryBuilder().deleteFeatureProperty());
                    ps.setString(1, property);
                    ps.setString(2, fp.getUid());
                    ps.executeUpdate();
                    JdbcUtils.closeStatement(ps);
                    ps = null;
                }
            }
            if (fp.getPermissions() != null) {
                for (String role : fp.getPermissions()) {
                    ps = sqlConn.prepareStatement(this.getQueryBuilder().deleteFeatureRole());
                    ps.setString(1, fp.getUid());
                    ps.setString(2, role);
                    ps.executeUpdate();
                    JdbcUtils.closeStatement(ps);
                    ps = null;
                }
            }
            ps = sqlConn.prepareStatement(this.getQueryBuilder().deleteFeature());
            ps.setString(1, fp.getUid());
            ps.executeUpdate();
            JdbcUtils.closeStatement(ps);
            ps = null;
            sqlConn.commit();
        }
        catch (SQLException sqlEX) {
            try {
                JdbcUtils.rollback(sqlConn);
                throw new FeatureAccessException(CANNOT_UPDATE_FEATURES_DATABASE_SQL_ERROR, sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn, previousAutoCommit);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn, previousAutoCommit);
    }

    @Override
    public void grantRoleOnFeature(String uid, String roleName) {
        this.assertFeatureExist(uid);
        Util.assertHasLength(roleName);
        this.update(this.getQueryBuilder().addRoleToFeature(), uid, roleName);
    }

    @Override
    public void removeRoleFromFeature(String uid, String roleName) {
        this.assertFeatureExist(uid);
        Util.assertHasLength(roleName);
        this.update(this.getQueryBuilder().deleteFeatureRole(), uid, roleName);
    }

    @Override
    public Map<String, Feature> readAll() {
        LinkedHashMap<String, Feature> uid;
        LinkedHashMap<String, Feature> mapFP = new LinkedHashMap<String, Feature>();
        Connection sqlConn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            sqlConn = this.dataSource.getConnection();
            ps = sqlConn.prepareStatement(this.getQueryBuilder().getAllFeatures());
            rs = ps.executeQuery();
            while (rs.next()) {
                Feature f = this.JDBC_FEATURE_MAPPER.mapFeature(rs);
                mapFP.put(f.getUid(), f);
            }
            JdbcUtils.closeResultSet(rs);
            rs = null;
            JdbcUtils.closeStatement(ps);
            ps = null;
            ps = sqlConn.prepareStatement(this.getQueryBuilder().getAllRoles());
            rs = ps.executeQuery();
            while (rs.next()) {
                uid = rs.getString("FEAT_UID");
                ((Feature)mapFP.get(uid)).getPermissions().add(rs.getString("ROLE_NAME"));
            }
            JdbcUtils.closeResultSet(rs);
            rs = null;
            JdbcUtils.closeStatement(ps);
            ps = null;
            for (Feature f : mapFP.values()) {
                ps = sqlConn.prepareStatement(this.getQueryBuilder().getFeatureProperties());
                ps.setString(1, f.getUid());
                rs = ps.executeQuery();
                while (rs.next()) {
                    f.addProperty(this.JDBC_PROPERTY_MAPPER.map(rs));
                }
                JdbcUtils.closeResultSet(rs);
                rs = null;
                JdbcUtils.closeStatement(ps);
                ps = null;
            }
            uid = mapFP;
        }
        catch (SQLException sqlEX) {
            try {
                throw new FeatureAccessException(CANNOT_CHECK_FEATURE_EXISTENCE_ERROR_RELATED_TO_DATABASE, sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet(rs);
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn);
        return uid;
    }

    @Override
    public Set<String> readAllGroups() {
        Object groupName;
        HashSet<Object> setOFGroup = new HashSet<Object>();
        Connection sqlConn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            sqlConn = this.dataSource.getConnection();
            ps = sqlConn.prepareStatement(this.getQueryBuilder().getAllGroups());
            rs = ps.executeQuery();
            while (rs.next()) {
                groupName = rs.getString("GROUPNAME");
                if (!Util.hasLength((String)groupName)) continue;
                setOFGroup.add(groupName);
            }
            groupName = setOFGroup;
        }
        catch (SQLException sqlEX) {
            try {
                throw new FeatureAccessException("Cannot list groups, error related to database", sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet(rs);
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn);
        return groupName;
    }

    @Override
    public void update(Feature fp) {
        this.assertFeatureNotNull(fp);
        Connection sqlConn = null;
        PreparedStatement ps = null;
        try {
            sqlConn = this.dataSource.getConnection();
            Feature fpExist = this.read(fp.getUid());
            int enable = 0;
            if (fp.isEnable()) {
                enable = 1;
            }
            String fStrategy = null;
            String fExpression = null;
            if (fp.getFlippingStrategy() != null) {
                fStrategy = fp.getFlippingStrategy().getClass().getName();
                fExpression = MappingUtil.fromMap(fp.getFlippingStrategy().getInitParams());
            }
            this.update(this.getQueryBuilder().updateFeature(), enable, fp.getDescription(), fStrategy, fExpression, fp.getGroup(), fp.getUid());
            HashSet<String> toBeDeleted = new HashSet<String>();
            toBeDeleted.addAll(fpExist.getPermissions());
            toBeDeleted.removeAll(fp.getPermissions());
            for (String roleToBeDelete : toBeDeleted) {
                this.removeRoleFromFeature(fpExist.getUid(), roleToBeDelete);
            }
            HashSet<String> toBeAdded = new HashSet<String>();
            toBeAdded.addAll(fp.getPermissions());
            toBeAdded.removeAll(fpExist.getPermissions());
            for (String string : toBeAdded) {
                this.grantRoleOnFeature(fpExist.getUid(), string);
            }
            ps = sqlConn.prepareStatement(this.getQueryBuilder().deleteAllFeatureCustomProperties());
            ps.setString(1, fpExist.getUid());
            ps.executeUpdate();
            JdbcUtils.closeStatement(ps);
            ps = null;
            for (Property property : fp.getCustomProperties().values()) {
                ps = this.createCustomProperty(sqlConn, fp.getUid(), property);
                JdbcUtils.closeStatement(ps);
                ps = null;
            }
        }
        catch (SQLException sqlEX) {
            try {
                throw new FeatureAccessException(CANNOT_CHECK_FEATURE_EXISTENCE_ERROR_RELATED_TO_DATABASE, sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn);
    }

    @Override
    public void clear() {
        Connection sqlConn = null;
        PreparedStatement ps = null;
        try {
            sqlConn = this.dataSource.getConnection();
            ps = sqlConn.prepareStatement(this.getQueryBuilder().deleteAllCustomProperties());
            ps.executeUpdate();
            JdbcUtils.closeStatement(ps);
            ps = null;
            ps = sqlConn.prepareStatement(this.getQueryBuilder().deleteAllRoles());
            ps.executeUpdate();
            JdbcUtils.closeStatement(ps);
            ps = null;
            ps = sqlConn.prepareStatement(this.getQueryBuilder().deleteAllFeatures());
            ps.executeUpdate();
            JdbcUtils.closeStatement(ps);
            ps = null;
        }
        catch (SQLException sqlEX) {
            try {
                throw new FeatureAccessException(CANNOT_CHECK_FEATURE_EXISTENCE_ERROR_RELATED_TO_DATABASE, sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn);
    }

    public void createCustomProperties(String uid, Collection<Property<?>> props) {
        Util.assertNotNull(uid, new Object[0]);
        if (props == null) {
            return;
        }
        Connection sqlConn = null;
        PreparedStatement ps = null;
        Boolean previousAutoCommit = null;
        try {
            sqlConn = this.dataSource.getConnection();
            previousAutoCommit = sqlConn.getAutoCommit();
            sqlConn.setAutoCommit(false);
            for (Property<?> pp : props) {
                ps = this.createCustomProperty(sqlConn, uid, pp);
                JdbcUtils.closeStatement(ps);
                ps = null;
            }
            sqlConn.commit();
        }
        catch (SQLException sqlEX) {
            try {
                JdbcUtils.rollback(sqlConn);
                throw new FeatureAccessException(CANNOT_CHECK_FEATURE_EXISTENCE_ERROR_RELATED_TO_DATABASE, sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn, previousAutoCommit);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn, previousAutoCommit);
    }

    private PreparedStatement createCustomProperty(Connection sqlConn, String featureId, Property<?> pp) throws SQLException {
        PreparedStatement ps = sqlConn.prepareStatement(this.getQueryBuilder().createFeatureProperty());
        ps.setString(1, pp.getName());
        ps.setString(2, pp.getType());
        ps.setString(3, pp.asString());
        ps.setString(4, pp.getDescription());
        if (pp.getFixedValues() != null && !pp.getFixedValues().isEmpty()) {
            String fixedValues = pp.getFixedValues().toString();
            ps.setString(5, fixedValues.substring(1, fixedValues.length() - 1));
        } else {
            ps.setString(5, null);
        }
        ps.setString(6, featureId);
        ps.executeUpdate();
        return ps;
    }

    @Override
    public boolean existGroup(String groupName) {
        boolean bl;
        Util.assertHasLength(groupName);
        Connection sqlConn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            sqlConn = this.dataSource.getConnection();
            ps = sqlConn.prepareStatement(this.getQueryBuilder().existGroup());
            ps.setString(1, groupName);
            rs = ps.executeQuery();
            rs.next();
            bl = rs.getInt(1) > 0;
        }
        catch (SQLException sqlEX) {
            try {
                throw new FeatureAccessException(CANNOT_CHECK_FEATURE_EXISTENCE_ERROR_RELATED_TO_DATABASE, sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet(rs);
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn);
        return bl;
    }

    @Override
    public void enableGroup(String groupName) {
        this.assertGroupExist(groupName);
        this.update(this.getQueryBuilder().enableGroup(), groupName);
    }

    @Override
    public void disableGroup(String groupName) {
        this.assertGroupExist(groupName);
        this.update(this.getQueryBuilder().disableGroup(), groupName);
    }

    @Override
    public Map<String, Feature> readGroup(String groupName) {
        Object uid;
        this.assertGroupExist(groupName);
        LinkedHashMap<String, Feature> mapFP = new LinkedHashMap<String, Feature>();
        Connection sqlConn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            sqlConn = this.dataSource.getConnection();
            ps = sqlConn.prepareStatement(this.getQueryBuilder().getFeatureOfGroup());
            ps.setString(1, groupName);
            rs = ps.executeQuery();
            while (rs.next()) {
                Feature f = this.JDBC_FEATURE_MAPPER.mapFeature(rs);
                mapFP.put(f.getUid(), f);
            }
            JdbcUtils.closeResultSet(rs);
            rs = null;
            JdbcUtils.closeStatement(ps);
            ps = null;
            ps = sqlConn.prepareStatement(this.getQueryBuilder().getAllRoles());
            rs = ps.executeQuery();
            while (rs.next()) {
                uid = rs.getString("FEAT_UID");
                if (!mapFP.containsKey(uid)) continue;
                ((Feature)mapFP.get(uid)).getPermissions().add(rs.getString("ROLE_NAME"));
            }
            JdbcUtils.closeResultSet(rs);
            rs = null;
            JdbcUtils.closeStatement(ps);
            ps = null;
            for (Feature f : mapFP.values()) {
                ps = sqlConn.prepareStatement(this.getQueryBuilder().getFeatureProperties());
                ps.setString(1, f.getUid());
                rs = ps.executeQuery();
                while (rs.next()) {
                    f.addProperty(this.JDBC_PROPERTY_MAPPER.map(rs));
                }
                JdbcUtils.closeResultSet(rs);
                rs = null;
                JdbcUtils.closeStatement(ps);
                ps = null;
            }
            uid = mapFP;
        }
        catch (SQLException sqlEX) {
            try {
                throw new FeatureAccessException(CANNOT_CHECK_FEATURE_EXISTENCE_ERROR_RELATED_TO_DATABASE, sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet(rs);
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn);
        return uid;
    }

    @Override
    public void addToGroup(String uid, String groupName) {
        this.assertFeatureExist(uid);
        Util.assertHasLength(groupName);
        this.update(this.getQueryBuilder().addFeatureToGroup(), groupName, uid);
    }

    @Override
    public void removeFromGroup(String uid, String groupName) {
        this.assertFeatureExist(uid);
        this.assertGroupExist(groupName);
        Feature feat = this.read(uid);
        if (feat.getGroup() != null && !feat.getGroup().equals(groupName)) {
            throw new IllegalArgumentException("'" + uid + "' is not in group '" + groupName + "'");
        }
        this.update(this.getQueryBuilder().addFeatureToGroup(), "", uid);
    }

    public void update(String query, Object ... params) {
        Connection sqlConnection = null;
        PreparedStatement ps = null;
        try {
            sqlConnection = this.dataSource.getConnection();
            ps = JdbcUtils.buildStatement(sqlConnection, query, params);
            ps.executeUpdate();
            if (!sqlConnection.getAutoCommit()) {
                sqlConnection.commit();
            }
        }
        catch (SQLException sqlEX) {
            try {
                throw new FeatureAccessException(CANNOT_UPDATE_FEATURES_DATABASE_SQL_ERROR, sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConnection);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConnection);
    }

    public DataSource getDataSource() {
        if (this.dataSource == null) {
            throw new IllegalStateException("DataSource has not been initialized");
        }
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public JdbcQueryBuilder getQueryBuilder() {
        if (this.queryBuilder == null) {
            this.queryBuilder = new JdbcQueryBuilder();
        }
        return this.queryBuilder;
    }

    public void setQueryBuilder(JdbcQueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }
}

