/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.conf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.ff4j.conf.XmlConfig;
import org.ff4j.conf.XmlParserErrorHandler;
import org.ff4j.core.Feature;
import org.ff4j.core.FlippingStrategy;
import org.ff4j.property.Property;
import org.ff4j.property.PropertyString;
import org.ff4j.utils.MappingUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public final class XmlParser {
    public static final String FEATURES_TAG = "features";
    public static final String FEATURE_TAG = "feature";
    public static final String FEATURE_ATT_UID = "uid";
    public static final String FEATURE_ATT_DESC = "description";
    public static final String FEATURE_ATT_ENABLE = "enable";
    public static final String FEATUREGROUP_TAG = "feature-group";
    public static final String FEATUREGROUP_ATTNAME = "name";
    public static final String FLIPSTRATEGY_TAG = "flipstrategy";
    public static final String PROPERTIES_TAG = "properties";
    public static final String PROPERTIES_CUSTOM_TAG = "custom-properties";
    public static final String PROPERTY_TAG = "property";
    public static final String PROPERTY_PARAMTYPE = "type";
    public static final String PROPERTY_PARAMNAME = "name";
    public static final String PROPERTY_PARAMDESCRIPTION = "description";
    public static final String PROPERTY_PARAMVALUE = "value";
    public static final String PROPERTY_PARAMFIXED_VALUES = "fixedValues";
    public static final String FLIPSTRATEGY_ATTCLASS = "class";
    public static final String FLIPSTRATEGY_PARAMTAG = "param";
    public static final String FLIPSTRATEGY_PARAMNAME = "name";
    public static final String FLIPSTRATEGY_PARAMVALUE = "value";
    public static final String SECURITY_TAG = "security";
    public static final String SECURITY_ROLE_TAG = "role";
    public static final String SECURITY_ROLE_ATTNAME = "name";
    public static final String CDATA_START = "<![CDATA[";
    public static final String CDATA_END = "]]>";
    private static final String ENCODING = "UTF-8";
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<ff4j xmlns=\"http://www.ff4j.org/schema/ff4j\"\n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n xsi:schemaLocation=\"http://www.ff4j.org/schema/ff4j http://ff4j.org/schema/ff4j-1.4.0.xsd\">>\n\n";
    private static final String XML_FEATURE = "  <feature uid=\"{0}\" description=\"{1}\" enable=\"{2}\">\n";
    private static final String XML_AUTH = "      <role name=\"{0}\" />\n";
    private static final String END_FEATURE = "  </feature>\n\n";
    private static final String BEGIN_FEATURES = " <features>\n\n";
    private static final String END_FEATURES = " </features>\n\n";
    private static final String BEGIN_PROPERTIES = " <properties>\n\n";
    private static final String BEGIN_CUSTOMPROPERTIES = "   <custom-properties>\n";
    private static final String END_CUSTOMPROPERTIES = "   </custom-properties>\n";
    private static final String END_PROPERTIES = " </properties>\n\n";
    private static final String END_FF4J = "</ff4j>\n\n";
    public static final String ERROR_SYNTAX_IN_CONFIGURATION_FILE = "Error syntax in configuration file : ";
    private static DocumentBuilder builder = null;

    public XmlConfig parseConfigurationFile(InputStream in) {
        try {
            NodeList pList;
            XmlConfig xmlConf = new XmlConfig();
            Document ff4jDocument = XmlParser.getDocumentBuilder().parse(in);
            NodeList fList = ff4jDocument.getElementsByTagName(FEATURES_TAG);
            if (fList.getLength() > 1) {
                throw new IllegalArgumentException("Root Tag is 'features' and must be unique, please check");
            }
            if (fList.getLength() == 1) {
                xmlConf.setFeatures(this.parseFeaturesTag((Element)fList.item(0)));
            }
            if ((pList = ff4jDocument.getElementsByTagName(PROPERTIES_TAG)).getLength() > 1) {
                throw new IllegalArgumentException("Root Tag is 'properties' and must be unique, please check");
            }
            if (pList.getLength() == 1) {
                xmlConf.setProperties(this.parsePropertiesTag((Element)pList.item(0)));
            }
            return xmlConf;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot parse XML data, please check file access ", e);
        }
    }

    public Map<String, Feature> parseFeaturesTag(Element featuresTag) {
        LinkedHashMap<String, Feature> xmlFeatures = new LinkedHashMap<String, Feature>();
        NodeList firstLevelNodes = featuresTag.getChildNodes();
        for (int i = 0; i < firstLevelNodes.getLength(); ++i) {
            if (!(firstLevelNodes.item(i) instanceof Element)) continue;
            Element currentCore = (Element)firstLevelNodes.item(i);
            if (FEATURE_TAG.equals(currentCore.getNodeName())) {
                Feature singleFeature = this.parseFeatureTag(currentCore);
                xmlFeatures.put(singleFeature.getUid(), singleFeature);
                continue;
            }
            if (FEATUREGROUP_TAG.equals(currentCore.getNodeName())) {
                xmlFeatures.putAll(this.parseFeatureGroupTag(currentCore));
                continue;
            }
            throw new IllegalArgumentException("Invalid XML Format, Features sub nodes are [feature,feature-group]");
        }
        return xmlFeatures;
    }

    private Map<String, Feature> parseFeatureGroupTag(Element featGroupTag) {
        NamedNodeMap nnm = featGroupTag.getAttributes();
        if (nnm.getNamedItem("name") == null) {
            throw new IllegalArgumentException("Error syntax in configuration featuregroup : must have 'name' attribute");
        }
        String groupName = nnm.getNamedItem("name").getNodeValue();
        HashMap<String, Feature> groupFeatures = new HashMap<String, Feature>();
        NodeList listOfFeat = featGroupTag.getElementsByTagName(FEATURE_TAG);
        for (int k = 0; k < listOfFeat.getLength(); ++k) {
            Feature f = this.parseFeatureTag((Element)listOfFeat.item(k));
            f.setGroup(groupName);
            groupFeatures.put(f.getUid(), f);
        }
        return groupFeatures;
    }

    private Feature parseFeatureTag(Element featXmlTag) {
        NodeList properties;
        NodeList securities;
        NamedNodeMap nnm = featXmlTag.getAttributes();
        if (nnm.getNamedItem(FEATURE_ATT_UID) == null) {
            throw new IllegalArgumentException("Error syntax in configuration file : 'uid' is required for each feature");
        }
        String uid = nnm.getNamedItem(FEATURE_ATT_UID).getNodeValue();
        if (nnm.getNamedItem(FEATURE_ATT_ENABLE) == null) {
            throw new IllegalArgumentException("Error syntax in configuration file : 'enable' is required for each feature (check " + uid + ")");
        }
        boolean enable = Boolean.parseBoolean(nnm.getNamedItem(FEATURE_ATT_ENABLE).getNodeValue());
        Feature f = new Feature(uid, enable, XmlParser.parseDescription(nnm));
        NodeList flipStrategies = featXmlTag.getElementsByTagName(FLIPSTRATEGY_TAG);
        if (flipStrategies.getLength() > 0) {
            f.setFlippingStrategy(this.parseFlipStrategy((Element)flipStrategies.item(0), f.getUid()));
        }
        if ((securities = featXmlTag.getElementsByTagName(SECURITY_TAG)).getLength() > 0) {
            f.setPermissions(XmlParser.parseListAuthorizations((Element)securities.item(0)));
        }
        if ((properties = featXmlTag.getElementsByTagName(PROPERTIES_CUSTOM_TAG)).getLength() > 0) {
            f.setCustomProperties(this.parsePropertiesTag((Element)properties.item(0)));
        }
        return f;
    }

    private Map<String, Property<?>> parsePropertiesTag(Element propertiesTag) {
        HashMap properties = new HashMap();
        NodeList lisOfProperties = propertiesTag.getElementsByTagName(PROPERTY_TAG);
        for (int k = 0; k < lisOfProperties.getLength(); ++k) {
            NodeList listOfFixedValue;
            Element propertyTag = (Element)lisOfProperties.item(k);
            NamedNodeMap attMap = propertyTag.getAttributes();
            if (attMap.getNamedItem("name") == null) {
                throw new IllegalArgumentException("Invalid XML Syntax, 'name' is a required attribute of 'property' TAG");
            }
            if (attMap.getNamedItem("value") == null) {
                throw new IllegalArgumentException("Invalid XML Syntax, 'value' is a required attribute of 'property' TAG");
            }
            String name = attMap.getNamedItem("name").getNodeValue();
            String value = attMap.getNamedItem("value").getNodeValue();
            Property ap = new PropertyString(name, value);
            if (null != attMap.getNamedItem(PROPERTY_PARAMTYPE)) {
                String optionalType = attMap.getNamedItem(PROPERTY_PARAMTYPE).getNodeValue();
                optionalType = MappingUtil.mapPropertyType(optionalType);
                try {
                    Constructor<?> constr = Class.forName(optionalType).getConstructor(String.class, String.class);
                    ap = (Property)constr.newInstance(name, value);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Cannot instantiate '" + optionalType + "' check default constructor", e);
                }
            }
            if (null != attMap.getNamedItem("description")) {
                ap.setDescription(attMap.getNamedItem("description").getNodeValue());
            }
            if ((listOfFixedValue = propertyTag.getElementsByTagName(PROPERTY_PARAMFIXED_VALUES)).getLength() != 0) {
                Element fixedValueTag = (Element)listOfFixedValue.item(0);
                NodeList listOfValues = fixedValueTag.getElementsByTagName("value");
                for (int l = 0; l < listOfValues.getLength(); ++l) {
                    Element valueTag = (Element)listOfValues.item(l);
                    ap.add2FixedValueFromString(valueTag.getTextContent());
                }
            }
            if (ap.getFixedValues() != null && !ap.getFixedValues().contains(ap.getValue())) {
                throw new IllegalArgumentException("Cannot create property <" + ap.getName() + "> invalid value <" + ap.getValue() + "> expected one of " + ap.getFixedValues());
            }
            properties.put(name, ap);
        }
        return properties;
    }

    private FlippingStrategy parseFlipStrategy(Element flipStrategyTag, String uid) {
        FlippingStrategy flipStrategy;
        NamedNodeMap nnm = flipStrategyTag.getAttributes();
        if (nnm.getNamedItem(FLIPSTRATEGY_ATTCLASS) == null) {
            throw new IllegalArgumentException("Error syntax in configuration file : 'class' is required for each flipstrategy (feature=" + uid + ")");
        }
        try {
            String clazzName = nnm.getNamedItem(FLIPSTRATEGY_ATTCLASS).getNodeValue();
            flipStrategy = (FlippingStrategy)Class.forName(clazzName).newInstance();
            LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
            NodeList initparamsNodes = flipStrategyTag.getElementsByTagName(FLIPSTRATEGY_PARAMTAG);
            for (int k = 0; k < initparamsNodes.getLength(); ++k) {
                Element param = (Element)initparamsNodes.item(k);
                NamedNodeMap nnmap = param.getAttributes();
                if (nnmap.getNamedItem("name") == null) {
                    throw new IllegalArgumentException("Error syntax in configuration file : 'name' is required for each param in flipstrategy(check " + uid + ")");
                }
                String currentParamName = nnmap.getNamedItem("name").getNodeValue();
                if (nnmap.getNamedItem("value") != null) {
                    parameters.put(currentParamName, nnmap.getNamedItem("value").getNodeValue());
                    continue;
                }
                if (param.getFirstChild() != null) {
                    parameters.put(currentParamName, param.getFirstChild().getNodeValue());
                    continue;
                }
                throw new IllegalArgumentException("Parameter '" + currentParamName + "' in feature '" + uid + "' has no value, please check XML");
            }
            flipStrategy.init(uid, parameters);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("An error occurs during flipstrategy parsing TAG" + uid, e);
        }
        return flipStrategy;
    }

    private static String parseDescription(NamedNodeMap nnm) {
        String desc = null;
        if (nnm.getNamedItem("description") != null) {
            desc = nnm.getNamedItem("description").getNodeValue();
        }
        return desc;
    }

    private static Set<String> parseListAuthorizations(Element securityTag) {
        TreeSet<String> authorizations = new TreeSet<String>();
        NodeList lisOfAuth = securityTag.getElementsByTagName(SECURITY_ROLE_TAG);
        for (int k = 0; k < lisOfAuth.getLength(); ++k) {
            Element role = (Element)lisOfAuth.item(k);
            authorizations.add(role.getAttributes().getNamedItem("name").getNodeValue());
        }
        return authorizations;
    }

    public static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (builder == null) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
            builder = dbf.newDocumentBuilder();
            builder.setErrorHandler(new XmlParserErrorHandler());
        }
        return builder;
    }

    public InputStream exportFeatures(Map<String, Feature> mapOfFeatures) throws IOException {
        return new ByteArrayInputStream(this.exportFeaturesPart(mapOfFeatures).getBytes(ENCODING));
    }

    public InputStream exportProperties(Map<String, Property<?>> mapOfProperties) throws IOException {
        return new ByteArrayInputStream(this.exportPropertiesPart(mapOfProperties).getBytes(ENCODING));
    }

    public InputStream exportAll(Map<String, Feature> mapOfFeatures, Map<String, Property<?>> mapOfProperties) throws IOException {
        StringBuilder sb = new StringBuilder(XML_HEADER);
        sb.append(this.exportFeaturesPart(mapOfFeatures));
        sb.append(this.exportPropertiesPart(mapOfProperties));
        sb.append(END_FF4J);
        return new ByteArrayInputStream(sb.toString().getBytes(ENCODING));
    }

    public InputStream exportAll(XmlConfig conf) throws IOException {
        return this.exportAll(conf.getFeatures(), conf.getProperties());
    }

    private String exportPropertiesPart(Map<String, Property<?>> mapOfProperties) {
        StringBuilder sb = new StringBuilder(BEGIN_PROPERTIES);
        if (mapOfProperties != null && !mapOfProperties.isEmpty()) {
            sb.append(this.buildPropertiesPart(mapOfProperties));
        }
        sb.append(END_PROPERTIES);
        return sb.toString();
    }

    private String exportFeaturesPart(Map<String, Feature> mapOfFeatures) {
        StringBuilder sb = new StringBuilder(BEGIN_FEATURES);
        HashMap featuresPerGroup = new HashMap();
        if (mapOfFeatures != null && !mapOfFeatures.isEmpty()) {
            for (Feature feature : mapOfFeatures.values()) {
                String groupName = feature.getGroup();
                if (!featuresPerGroup.containsKey(groupName)) {
                    featuresPerGroup.put(groupName, new ArrayList());
                }
                ((List)featuresPerGroup.get(groupName)).add(feature);
            }
        }
        for (Map.Entry entry : featuresPerGroup.entrySet()) {
            if (null != entry.getKey() && !((String)entry.getKey()).isEmpty()) {
                sb.append(" <feature-group name=\"" + (String)entry.getKey() + "\" >\n\n");
            }
            for (Feature feat : (List)entry.getValue()) {
                Map<String, Property<?>> map;
                FlippingStrategy fs;
                sb.append(MessageFormat.format(XML_FEATURE, feat.getUid(), feat.getDescription(), feat.isEnable()));
                if (null != feat.getPermissions() && !feat.getPermissions().isEmpty()) {
                    sb.append("   <security>\n");
                    for (String string : feat.getPermissions()) {
                        sb.append(MessageFormat.format(XML_AUTH, string));
                    }
                    sb.append("   </security>\n");
                }
                if (null != (fs = feat.getFlippingStrategy())) {
                    sb.append("   <flipstrategy class=\"" + fs.getClass().getName() + "\" >\n");
                    for (String p : fs.getInitParams().keySet()) {
                        sb.append("     <param name=\"");
                        sb.append(p);
                        sb.append("\" value=\"");
                        String paramValue = fs.getInitParams().get(p);
                        sb.append(this.escapeXML(paramValue));
                        sb.append("\" />\n");
                    }
                    sb.append("   </flipstrategy>\n");
                }
                if ((map = feat.getCustomProperties()) != null && !map.isEmpty()) {
                    sb.append(BEGIN_CUSTOMPROPERTIES);
                    sb.append(this.buildPropertiesPart(feat.getCustomProperties()));
                    sb.append(END_CUSTOMPROPERTIES);
                }
                sb.append(END_FEATURE);
            }
            if (null == entry.getKey() || ((String)entry.getKey()).isEmpty()) continue;
            sb.append(" </feature-group>\n\n");
        }
        sb.append(END_FEATURES);
        return sb.toString();
    }

    private String buildPropertiesPart(Map<String, Property<?>> props) {
        StringBuilder sb = new StringBuilder();
        if (props != null && !props.isEmpty()) {
            for (Property<?> property : props.values()) {
                sb.append("    <property name=\"" + property.getName() + "\" ");
                sb.append("value=\"" + property.asString() + "\" ");
                if (!(property instanceof PropertyString)) {
                    sb.append("type=\"" + property.getClass().getName() + "\"");
                }
                if (property.getFixedValues() != null && !property.getFixedValues().isEmpty()) {
                    sb.append(">\n");
                    sb.append("     <fixedValues>\n");
                    for (Object o : property.getFixedValues()) {
                        sb.append("      <value>" + o.toString() + "</value>\n");
                    }
                    sb.append("     </fixedValues>\n");
                    sb.append("    </property>\n");
                    continue;
                }
                sb.append("/>\n");
            }
        }
        return sb.toString();
    }

    public String escapeXML(String value) {
        if (value == null) {
            return null;
        }
        return value.replaceAll("&", "&amp;").replaceAll(">", "&gt;").replaceAll("<", "&lt;");
    }
}

