/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.utils;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.ff4j.cache.FF4jCacheProxy;
import org.ff4j.core.FlippingStrategy;
import org.ff4j.property.Property;

public class JsonUtils {
    private JsonUtils() {
    }

    public static final String escapeJson(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder output = new StringBuilder();
        int len = value.length();
        block10: for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '\"': {
                    output.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    output.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    output.append("\\b");
                    continue block10;
                }
                case '\f': {
                    output.append("\\f");
                    continue block10;
                }
                case '\n': {
                    output.append("\\n");
                    continue block10;
                }
                case '\r': {
                    output.append("\\r");
                    continue block10;
                }
                case '\t': {
                    output.append("\\t");
                    continue block10;
                }
                case '/': {
                    output.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String ss = Integer.toHexString(ch);
                        output.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            output.append('0');
                        }
                        output.append(ss.toUpperCase());
                        continue block10;
                    }
                    output.append(ch);
                }
            }
        }
        return output.toString();
    }

    public static final String valueAsJson(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "\"" + JsonUtils.escapeJson(value.toString()) + "\"";
        }
        return value.toString();
    }

    public static final <T> String collectionAsJson(Collection<T> pCollec) {
        if (pCollec == null) {
            return "null";
        }
        if (pCollec.isEmpty()) {
            return "[]";
        }
        StringBuilder json = new StringBuilder("[");
        boolean first = true;
        for (T element : pCollec) {
            json.append(first ? "" : ",");
            json.append(JsonUtils.valueAsJson(element));
            first = false;
        }
        json.append("]");
        return json.toString();
    }

    public static final <K, V> String mapAsJson(Map<K, V> pMap) {
        if (pMap == null) {
            return "null";
        }
        if (pMap.isEmpty()) {
            return "{}";
        }
        StringBuilder json = new StringBuilder("{");
        boolean first = true;
        for (Map.Entry<K, V> mapEntry : pMap.entrySet()) {
            json.append(first ? "" : ",");
            json.append(JsonUtils.valueAsJson(mapEntry.getKey()) + ":");
            json.append(JsonUtils.valueAsJson(mapEntry.getValue()));
            first = false;
        }
        json.append("}");
        return json.toString();
    }

    public static final String cacheJson(Object store) {
        StringBuilder sb = new StringBuilder();
        if (store instanceof FF4jCacheProxy) {
            FF4jCacheProxy cacheProxy = (FF4jCacheProxy)store;
            sb.append(",\"cached\":true");
            sb.append(",\"cacheProvider\":\"" + cacheProxy.getCacheProvider() + "\"");
            sb.append(",\"cacheStore\":\"" + cacheProxy.getCachedTargetStore() + "\"");
        } else {
            sb.append(",\"cached\":false");
        }
        return sb.toString();
    }

    public static final String permissionsAsJson(Set<String> permissions) {
        return JsonUtils.collectionAsJson(permissions);
    }

    public static final String flippingStrategyAsJson(FlippingStrategy flippingStrategy) {
        if (flippingStrategy == null) {
            return "null";
        }
        StringBuilder json = new StringBuilder("{");
        json.append(JsonUtils.valueAsJson("initParams") + ":");
        json.append(JsonUtils.mapAsJson(flippingStrategy.getInitParams()));
        json.append("," + JsonUtils.valueAsJson("type") + ":");
        json.append(JsonUtils.valueAsJson(flippingStrategy.getClass().getName()));
        json.append("}");
        return json.toString();
    }

    public static final String customPropertiesAsJson(Map<String, ? extends Property<?>> customProperties) {
        return JsonUtils.mapAsJson(customProperties);
    }
}

