/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.spring.boot.web.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.ff4j.services.FeatureServices;
import org.ff4j.services.domain.FeatureApiBean;
import org.ff4j.spring.boot.web.api.utils.FeatureWebUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Feature"}, description="The API for Feature related operations")
@RestController
@RequestMapping(value={"/api/ff4j/store/features/{uid}"})
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\b\b\u0001\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\nH\u0017J\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b2\b\b\u0001\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0017J\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0017J\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0017J\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0017J\u0012\u0010\u0013\u001a\u00020\u000f2\b\b\u0001\u0010\t\u001a\u00020\nH\u0017J\"\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\b\b\u0001\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u0015\u001a\u00020\nH\u0017J\"\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\b\b\u0001\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\nH\u0017J\"\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\b\b\u0001\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u0015\u001a\u00020\nH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lorg/ff4j/spring/boot/web/api/resources/FeatureResource;", "", "featureServices", "Lorg/ff4j/services/FeatureServices;", "(Lorg/ff4j/services/FeatureServices;)V", "getFeatureServices", "()Lorg/ff4j/services/FeatureServices;", "addGroupToFeature", "Lorg/springframework/http/ResponseEntity;", "featureUID", "", "groupName", "createOrUpdateFeature", "", "featureApiBean", "Lorg/ff4j/services/domain/FeatureApiBean;", "deleteFeature", "disableFeature", "enableFeature", "getFeatureByUID", "grantRoleToFeature", "role", "removeGroupFromFeature", "removeRoleFromFeature", "ff4j-spring-boot-web-api"})
public class FeatureResource {
    @NotNull
    private final FeatureServices featureServices;

    @ApiOperation(value="Get feature by uid", response=FeatureApiBean.class)
    @GetMapping(produces={"application/json"})
    @NotNull
    public FeatureApiBean getFeatureByUID(@PathVariable(value="uid") @NotNull String featureUID) {
        Intrinsics.checkNotNullParameter((Object)featureUID, (String)"featureUID");
        return this.getFeatureServices().getFeature(featureUID);
    }

    @ApiOperation(value="Create or update a feature", response=ResponseEntity.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Feature uid is blank (or) feature uid did not match with the requested feature uid to be created or updated"), @ApiResponse(code=201, message="Feature has been created"), @ApiResponse(code=202, message="Feature has been updated"), @ApiResponse(code=204, message="No content, no changes made to the feature")})
    @PutMapping(consumes={"application/json"}, produces={"application/json"})
    @NotNull
    public ResponseEntity<Boolean> createOrUpdateFeature(@PathVariable(value="uid") @NotNull String featureUID, @RequestBody @NotNull FeatureApiBean featureApiBean) {
        Intrinsics.checkNotNullParameter((Object)featureUID, (String)"featureUID");
        Intrinsics.checkNotNullParameter((Object)featureApiBean, (String)"featureApiBean");
        return FeatureWebUtils.INSTANCE.getBooleanResponseEntityByHttpStatus(this.getFeatureServices().createOrUpdateFeature(featureUID, featureApiBean));
    }

    @ApiOperation(value="Delete a feature", response=ResponseEntity.class)
    @ApiResponses(value={@ApiResponse(code=204, message="No content, feature is deleted"), @ApiResponse(code=404, message="Feature not found")})
    @DeleteMapping
    @NotNull
    public ResponseEntity<Object> deleteFeature(@PathVariable(value="uid") @NotNull String featureUID) {
        Intrinsics.checkNotNullParameter((Object)featureUID, (String)"featureUID");
        this.getFeatureServices().deleteFeature(featureUID);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @ApiOperation(value="Enable a feature", response=ResponseEntity.class)
    @ApiResponses(value={@ApiResponse(code=202, message="Features has been enabled"), @ApiResponse(code=404, message="Feature not found")})
    @PostMapping(consumes={"application/json"}, value={"/enable"})
    @NotNull
    public ResponseEntity<Object> enableFeature(@PathVariable(value="uid") @NotNull String featureUID) {
        Intrinsics.checkNotNullParameter((Object)featureUID, (String)"featureUID");
        this.getFeatureServices().enableFeature(featureUID);
        return new ResponseEntity(HttpStatus.ACCEPTED);
    }

    @ApiOperation(value="Disable a feature", response=ResponseEntity.class)
    @ApiResponses(value={@ApiResponse(code=202, message="Features has been disabled"), @ApiResponse(code=404, message="Feature not found")})
    @PostMapping(consumes={"application/json"}, value={"/disable"})
    @NotNull
    public ResponseEntity<Object> disableFeature(@PathVariable(value="uid") @NotNull String featureUID) {
        Intrinsics.checkNotNullParameter((Object)featureUID, (String)"featureUID");
        this.getFeatureServices().disableFeature(featureUID);
        return new ResponseEntity(HttpStatus.ACCEPTED);
    }

    @ApiOperation(value="Grant a permission to a feature", response=ResponseEntity.class)
    @ApiResponses(value={@ApiResponse(code=202, message="Permission has been granted"), @ApiResponse(code=404, message="Feature not found"), @ApiResponse(code=304, message="Role already exists, nothing to update")})
    @PostMapping(consumes={"application/json"}, value={"/grantrole/{role}"})
    @NotNull
    public ResponseEntity<Object> grantRoleToFeature(@PathVariable(value="uid") @NotNull String featureUID, @PathVariable(value="role") @NotNull String role) {
        Intrinsics.checkNotNullParameter((Object)featureUID, (String)"featureUID");
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        this.getFeatureServices().grantRoleToFeature(featureUID, role);
        return new ResponseEntity(HttpStatus.ACCEPTED);
    }

    @ApiOperation(value="Remove a permission from a feature", response=ResponseEntity.class)
    @ApiResponses(value={@ApiResponse(code=202, message="Permission has been granted"), @ApiResponse(code=404, message="Feature not found")})
    @PostMapping(consumes={"application/json"}, value={"/removerole/{role}"})
    @NotNull
    public ResponseEntity<Object> removeRoleFromFeature(@PathVariable(value="uid") @NotNull String featureUID, @PathVariable(value="role") @NotNull String role) {
        Intrinsics.checkNotNullParameter((Object)featureUID, (String)"featureUID");
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        this.getFeatureServices().removeRoleFromFeature(featureUID, role);
        return new ResponseEntity(HttpStatus.ACCEPTED);
    }

    @ApiOperation(value="Define the group of the feature", response=ResponseEntity.class)
    @ApiResponses(value={@ApiResponse(code=202, message="Group has been defined"), @ApiResponse(code=404, message="Feature not found"), @ApiResponse(code=304, message="Group already exists, nothing to update")})
    @PostMapping(consumes={"application/json"}, value={"/addGroup/{groupName}"})
    @NotNull
    public ResponseEntity<Object> addGroupToFeature(@PathVariable(value="uid") @NotNull String featureUID, @PathVariable(value="groupName") @NotNull String groupName) {
        Intrinsics.checkNotNullParameter((Object)featureUID, (String)"featureUID");
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        this.getFeatureServices().addGroupToFeature(featureUID, groupName);
        return new ResponseEntity(HttpStatus.ACCEPTED);
    }

    @ApiOperation(value="Remove the group of the feature", response=ResponseEntity.class)
    @ApiResponses(value={@ApiResponse(code=204, message="Group has been removed"), @ApiResponse(code=404, message="Feature not found")})
    @PostMapping(consumes={"application/json"}, value={"/removeGroup/{groupName}"})
    @NotNull
    public ResponseEntity<Object> removeGroupFromFeature(@PathVariable(value="uid") @NotNull String featureUID, @PathVariable(value="groupName") @NotNull String groupName) {
        Intrinsics.checkNotNullParameter((Object)featureUID, (String)"featureUID");
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        this.getFeatureServices().removeGroupFromFeature(featureUID, groupName);
        return new ResponseEntity(HttpStatus.ACCEPTED);
    }

    @NotNull
    public FeatureServices getFeatureServices() {
        return this.featureServices;
    }

    public FeatureResource(@Autowired @NotNull FeatureServices featureServices) {
        Intrinsics.checkNotNullParameter((Object)featureServices, (String)"featureServices");
        this.featureServices = featureServices;
    }
}

