/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.store;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.ff4j.core.Feature;
import org.ff4j.exception.FeatureAlreadyExistException;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.exception.GroupNotFoundException;
import org.ff4j.store.AbstractFeatureStore;
import org.ff4j.store.mongodb.FeatureDBObjectBuilder;
import org.ff4j.store.mongodb.FeatureDBObjectMapper;
import org.ff4j.utils.Util;

public class FeatureStoreMongoDB
extends AbstractFeatureStore {
    public static final String FEATURE_IDENTIFIER_CANNOT_BE_NULL_NOR_EMPTY = "Feature identifier cannot be null nor empty";
    public static final String GROUPNAME_CANNOT_BE_NULL_NOR_EMPTY = "Groupname cannot be null nor empty";
    private static final FeatureDBObjectMapper MAPPER = new FeatureDBObjectMapper();
    private static final FeatureDBObjectBuilder BUILDER = new FeatureDBObjectBuilder();
    private String collectionName = "feature";
    private String dbName = "ff4j";
    private MongoClient mongoClient;
    private DBCollection featuresCollection;

    public FeatureStoreMongoDB() {
    }

    public FeatureStoreMongoDB(MongoClient client) {
        this.mongoClient = client;
        this.featuresCollection = this.getFeaturesCollection();
    }

    public FeatureStoreMongoDB(MongoClient client, String dbName, String collectionName) {
        this.mongoClient = client;
        this.collectionName = collectionName;
        this.dbName = dbName;
        this.featuresCollection = this.getFeaturesCollection();
    }

    public FeatureStoreMongoDB(DBCollection collection) {
        this.featuresCollection = collection;
        this.collectionName = this.featuresCollection.getName();
        this.dbName = this.featuresCollection.getDB().getName();
    }

    public FeatureStoreMongoDB(DBCollection collection, String xmlConfFile) {
        this(collection);
        this.importFeaturesFromXmlFile(xmlConfFile);
    }

    public void enable(String featId) {
        this.updateStatus(featId, true);
    }

    public void disable(String featId) {
        this.updateStatus(featId, false);
    }

    private void updateStatus(String uid, boolean enable) {
        Util.assertParamHasLength((String)uid, (String)"uid (feature identifier");
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        DBObject target = BUILDER.getFeatUid(uid);
        DBObject enabledd = BUILDER.getEnable(enable);
        this.getFeaturesCollection().update(target, BasicDBObjectBuilder.start((String)"$set", (Object)enabledd).get());
    }

    public boolean exist(String featId) {
        Util.assertHasLength((String[])new String[]{featId});
        return 1L == this.getFeaturesCollection().count(BUILDER.getFeatUid(featId));
    }

    public Feature read(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException(FEATURE_IDENTIFIER_CANNOT_BE_NULL_NOR_EMPTY);
        }
        DBObject object = this.getFeaturesCollection().findOne(BUILDER.getFeatUid(uid));
        if (object == null) {
            throw new FeatureNotFoundException(uid);
        }
        return MAPPER.mapFeature(object);
    }

    public void create(Feature fp) {
        if (fp == null) {
            throw new IllegalArgumentException("Feature cannot be null nor empty");
        }
        if (this.exist(fp.getUid())) {
            throw new FeatureAlreadyExistException(fp.getUid());
        }
        this.getFeaturesCollection().save(MAPPER.toDBObject(fp));
    }

    public void delete(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException(FEATURE_IDENTIFIER_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        this.getFeaturesCollection().remove(BUILDER.getFeatUid(uid));
    }

    public void grantRoleOnFeature(String uid, String roleName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException(FEATURE_IDENTIFIER_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (roleName == null || roleName.isEmpty()) {
            throw new IllegalArgumentException("roleName cannot be null nor empty");
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        this.getFeaturesCollection().update(BUILDER.getFeatUid(uid), (DBObject)new BasicDBObject("$addToSet", (Object)BUILDER.getRoles(roleName)));
    }

    public void removeRoleFromFeature(String uid, String roleName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException(FEATURE_IDENTIFIER_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (roleName == null || roleName.isEmpty()) {
            throw new IllegalArgumentException("roleName cannot be null nor empty");
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        this.getFeaturesCollection().update(BUILDER.getFeatUid(uid), (DBObject)new BasicDBObject("$pull", (Object)BUILDER.getRoles(roleName)));
    }

    public Map<String, Feature> readAll() {
        LinkedHashMap<String, Feature> mapFP = new LinkedHashMap<String, Feature>();
        for (DBObject dbObject : this.getFeaturesCollection().find()) {
            Feature feature = MAPPER.mapFeature(dbObject);
            mapFP.put(feature.getUid(), feature);
        }
        return mapFP;
    }

    public void update(Feature fp) {
        if (fp == null) {
            throw new IllegalArgumentException("Feature cannot be null nor empty");
        }
        this.read(fp.getUid());
        this.getFeaturesCollection().save(MAPPER.toDBObject(fp));
    }

    public boolean existGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException(GROUPNAME_CANNOT_BE_NULL_NOR_EMPTY);
        }
        return this.getFeaturesCollection().count(BUILDER.getGroupName(groupName)) > 0L;
    }

    public Set<String> readAllGroups() {
        HashSet<String> setOfGroups = new HashSet<String>();
        for (DBObject dbObject : this.getFeaturesCollection().find()) {
            setOfGroups.add((String)dbObject.get("groupname"));
        }
        setOfGroups.remove(null);
        setOfGroups.remove("");
        return setOfGroups;
    }

    public Map<String, Feature> readGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException(GROUPNAME_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
        LinkedHashMap<String, Feature> mapFP = new LinkedHashMap<String, Feature>();
        for (DBObject dbObject : this.getFeaturesCollection().find(BUILDER.getGroupName(groupName))) {
            Feature feature = MAPPER.mapFeature(dbObject);
            mapFP.put(feature.getUid(), feature);
        }
        return mapFP;
    }

    public void enableGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException(GROUPNAME_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
        for (DBObject dbObject : this.getFeaturesCollection().find(BUILDER.getGroupName(groupName))) {
            DBObject enabledd = BUILDER.getEnable(true);
            this.getFeaturesCollection().update(dbObject, BasicDBObjectBuilder.start((String)"$set", (Object)enabledd).get());
        }
    }

    public void disableGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException(GROUPNAME_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
        for (DBObject dbObject : this.getFeaturesCollection().find(BUILDER.getGroupName(groupName))) {
            DBObject enabledd = BUILDER.getEnable(false);
            this.getFeaturesCollection().update(dbObject, BasicDBObjectBuilder.start((String)"$set", (Object)enabledd).get());
        }
    }

    public void addToGroup(String uid, String groupName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException(FEATURE_IDENTIFIER_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException(GROUPNAME_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        DBObject target = BUILDER.getFeatUid(uid);
        DBObject nGroupName = BUILDER.getGroupName(groupName);
        this.getFeaturesCollection().update(target, BasicDBObjectBuilder.start((String)"$set", (Object)nGroupName).get());
    }

    public void removeFromGroup(String uid, String groupName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException(FEATURE_IDENTIFIER_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException(GROUPNAME_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
        DBObject target = BUILDER.getFeatUid(uid);
        DBObject nGroupName = BUILDER.getGroupName("");
        this.getFeaturesCollection().update(target, BasicDBObjectBuilder.start((String)"$set", (Object)nGroupName).get());
    }

    public void clear() {
        this.getFeaturesCollection().remove(BasicDBObjectBuilder.start().get());
    }

    public void createSchema() {
        if (!this.mongoClient.getDB(this.dbName).collectionExists(this.collectionName)) {
            BasicDBObject options = new BasicDBObject();
            options.put("size", (Object)10000);
            this.featuresCollection = this.mongoClient.getDB(this.dbName).createCollection(this.collectionName, (DBObject)options);
        }
        this.featuresCollection = this.mongoClient.getDB(this.dbName).getCollection(this.collectionName);
    }

    public DBCollection getFeaturesCollection() {
        if (this.featuresCollection == null) {
            if (this.mongoClient != null) {
                this.createSchema();
            } else {
                throw new IllegalStateException("Cannot initialize Features collection : no mongo client defined");
            }
        }
        return this.featuresCollection;
    }
}

