/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.store;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.ff4j.exception.PropertyAlreadyExistException;
import org.ff4j.property.Property;
import org.ff4j.property.store.AbstractPropertyStore;
import org.ff4j.store.mongodb.FeatureDBObjectMapper;
import org.ff4j.store.mongodb.PropertyDBObjectBuilder;
import org.ff4j.utils.Util;

public class PropertyStoreMongoDB
extends AbstractPropertyStore {
    private String collectionName = "property";
    private String dbName = "ff4j";
    private MongoClient mongoClient;
    private DBCollection propertiesCollection;
    private FeatureDBObjectMapper MAPPER = new FeatureDBObjectMapper();
    private static final PropertyDBObjectBuilder BUILDER = new PropertyDBObjectBuilder();

    public PropertyStoreMongoDB() {
    }

    public PropertyStoreMongoDB(MongoClient client) {
        this.mongoClient = client;
        this.propertiesCollection = this.getPropertiesCollection();
    }

    public PropertyStoreMongoDB(MongoClient client, String dbName, String collectionName) {
        this.mongoClient = client;
        this.collectionName = collectionName;
        this.dbName = dbName;
        this.propertiesCollection = this.getPropertiesCollection();
    }

    public PropertyStoreMongoDB(DBCollection collection) {
        this.propertiesCollection = collection;
        this.collectionName = collection.getName();
        this.dbName = collection.getDB().getName();
    }

    public PropertyStoreMongoDB(DBCollection collection, String xmlConfFile) {
        this(collection);
        this.importPropertiesFromXmlFile(xmlConfFile);
    }

    public boolean existProperty(String name) {
        Util.assertHasLength((String[])new String[]{name});
        return 1L == this.getPropertiesCollection().count(BUILDER.getName(name));
    }

    public <T> void createProperty(Property<T> prop) {
        if (prop == null) {
            throw new IllegalArgumentException("Property cannot be null nor empty");
        }
        if (this.existProperty(prop.getName())) {
            throw new PropertyAlreadyExistException(prop.getName());
        }
        this.getPropertiesCollection().save(this.MAPPER.fromProperty2DBObject(prop));
    }

    public Property<?> readProperty(String name) {
        this.assertPropertyExist(name);
        DBObject object = this.getPropertiesCollection().findOne(BUILDER.getName(name));
        return this.MAPPER.mapProperty(object);
    }

    public void deleteProperty(String name) {
        this.assertPropertyExist(name);
        this.getPropertiesCollection().remove(BUILDER.getName(name));
    }

    public void clear() {
        this.getPropertiesCollection().remove(BasicDBObjectBuilder.start().get());
    }

    public void updateProperty(String name, String newValue) {
        this.assertPropertyExist(name);
        this.readProperty(name).fromString(newValue);
        DBObject query = BUILDER.getName(name);
        DBObject update = BUILDER.getValue(newValue);
        this.getPropertiesCollection().update(query, BasicDBObjectBuilder.start((String)"$set", (Object)update).get());
    }

    public <T> void updateProperty(Property<T> prop) {
        Util.assertNotNull((Object[])new Object[]{prop});
        this.deleteProperty(prop.getName());
        this.createProperty(prop);
    }

    public Map<String, Property<?>> readAllProperties() {
        LinkedHashMap mapP = new LinkedHashMap();
        for (DBObject dbObject : this.getPropertiesCollection().find()) {
            Property<?> prop = this.MAPPER.mapProperty(dbObject);
            mapP.put(prop.getName(), prop);
        }
        return mapP;
    }

    public Set<String> listPropertyNames() {
        HashSet<String> properties = new HashSet<String>();
        for (DBObject dbObject : this.getPropertiesCollection().find((DBObject)new BasicDBObject(), new BasicDBObjectBuilder().add("name", (Object)true).get())) {
            properties.add((String)dbObject.get("name"));
        }
        return properties;
    }

    public void createSchema() {
        if (!this.mongoClient.getDB(this.dbName).collectionExists(this.collectionName)) {
            BasicDBObject options = new BasicDBObject();
            options.put("size", (Object)10000);
            this.mongoClient.getDB(this.dbName).createCollection(this.collectionName, (DBObject)options);
        }
        this.propertiesCollection = this.mongoClient.getDB(this.dbName).getCollection(this.collectionName);
    }

    public DBCollection getPropertiesCollection() {
        if (this.propertiesCollection == null) {
            if (this.mongoClient != null) {
                this.createSchema();
            } else {
                throw new IllegalStateException("Cannot initialize Properties collection : no mongo client defined");
            }
        }
        return this.propertiesCollection;
    }
}

