/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.store.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ff4j.core.Feature;
import org.ff4j.core.FlippingStrategy;
import org.ff4j.property.Property;
import org.ff4j.property.util.PropertyJsonBean;
import org.ff4j.store.mongodb.FeatureDBObjectBuilder;
import org.ff4j.store.mongodb.PropertyDBObjectBuilder;
import org.ff4j.utils.JsonUtils;
import org.ff4j.utils.MappingUtil;

public final class FeatureDBObjectMapper {
    public Feature mapFeature(DBObject dbObject) {
        String featUid = (String)dbObject.get("_id");
        boolean status = (Boolean)dbObject.get("enable");
        Feature f = new Feature(featUid, status);
        f.setDescription((String)dbObject.get("description"));
        f.setGroup((String)dbObject.get("groupname"));
        f.setPermissions(this.mapAuthorization(dbObject));
        f.setFlippingStrategy(this.mapStrategy(featUid, dbObject));
        f.setCustomProperties(this.mapCustomProperties(dbObject));
        return f;
    }

    public Property<?> mapProperty(DBObject dbObject) {
        BasicDBList dbList;
        PropertyJsonBean pf = new PropertyJsonBean();
        pf.setName((String)dbObject.get("name"));
        pf.setDescription((String)dbObject.get("description"));
        pf.setType((String)dbObject.get("type"));
        pf.setValue((String)dbObject.get("value"));
        if (dbObject.containsField("fixedValues") && (dbList = (BasicDBList)dbObject.get("fixedValues")) != null) {
            for (Object item : dbList) {
                pf.addFixedValue((String)item);
            }
        }
        return pf.asProperty();
    }

    public DBObject toDBObject(Feature feature) {
        String strategyColumn = null;
        String expressionColumn = null;
        if (feature.getFlippingStrategy() != null) {
            strategyColumn = feature.getFlippingStrategy().getClass().getName();
            expressionColumn = MappingUtil.fromMap((Map)feature.getFlippingStrategy().getInitParams());
        }
        String customProperties = null;
        if (feature.getCustomProperties() != null) {
            customProperties = JsonUtils.customPropertiesAsJson((Map)feature.getCustomProperties());
        }
        return new FeatureDBObjectBuilder().addFeatUid(feature.getUid()).addEnable(feature.isEnable()).addDescription(feature.getDescription()).addGroupName(feature.getGroup()).addStrategy(strategyColumn).addExpression(expressionColumn).addCustomProperties(customProperties).addRoles(feature.getPermissions()).build();
    }

    public DBObject fromProperty2DBObject(Property<?> property) {
        PropertyJsonBean pjb = new PropertyJsonBean(property);
        return new PropertyDBObjectBuilder().addName(pjb.getName()).addType(pjb.getType()).addValue(pjb.getValue()).addDescription(pjb.getDescription()).addFixedValues(pjb.getFixedValues()).build();
    }

    private Set<String> mapAuthorization(DBObject dbObject) {
        HashSet<String> authorisation = new HashSet<String>();
        if (dbObject.containsField("roles")) {
            for (Object role : (Iterable)dbObject.get("roles")) {
                authorisation.add(role.toString());
            }
        }
        return authorisation;
    }

    private FlippingStrategy mapStrategy(String featUid, DBObject dbObject) {
        String strategy = (String)dbObject.get("strategy");
        Map initParams = MappingUtil.toMap((String)((String)dbObject.get("expression")));
        if (strategy != null && !"".equals(strategy)) {
            return MappingUtil.instanceFlippingStrategy((String)featUid, (String)strategy, (Map)initParams);
        }
        return null;
    }

    private Map<String, Property<?>> mapCustomProperties(DBObject dbObject) {
        HashMap mapOfCustomProperties = new HashMap();
        if (dbObject.containsField("customProperties")) {
            String properties = (String)dbObject.get("customProperties");
            Map values = (Map)JSON.parse((String)properties);
            for (Map.Entry entry : values.entrySet()) {
                mapOfCustomProperties.put((String)entry.getKey(), this.mapProperty((DBObject)entry.getValue()));
            }
        }
        return mapOfCustomProperties;
    }
}

