/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.ds;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.sql.Statement;
import org.firebirdsql.ds.PooledConnectionHandler;
import org.firebirdsql.ds.ReflectionHelper;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdStatement;

class StatementHandler
implements InvocationHandler {
    private final PooledConnectionHandler owner;
    private volatile Statement stmt;
    private volatile Statement proxy;
    private static final Method STATEMENT_IS_CLOSED = ReflectionHelper.findMethod(Statement.class, "isClosed", new Class[0]);
    private static final Method FIREBIRDSTATEMENT_IS_CLOSED = ReflectionHelper.findMethod(FirebirdStatement.class, "isClosed", new Class[0]);
    private static final Method STATEMENT_CLOSE = ReflectionHelper.findMethod(Statement.class, "close", new Class[0]);
    private static final Method GET_CONNECTION = ReflectionHelper.findMethod(Statement.class, "getConnection", new Class[0]);
    private static final Method TO_STRING = ReflectionHelper.findMethod(Object.class, "toString", new Class[0]);
    private static final Method EQUALS = ReflectionHelper.findMethod(Object.class, "equals", new Class[]{Object.class});
    private static final Method HASH_CODE = ReflectionHelper.findMethod(Object.class, "hashCode", new Class[0]);

    StatementHandler(PooledConnectionHandler owner, Statement stmt) {
        this.owner = owner;
        this.stmt = stmt;
        this.proxy = (Statement)Proxy.newProxyInstance(this.getClass().getClassLoader(), ReflectionHelper.getAllInterfaces(stmt.getClass()), (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.equals(TO_STRING)) {
            return "Proxy for " + this.stmt;
        }
        if (method.equals(EQUALS)) {
            return proxy == args[0];
        }
        if (method.equals(HASH_CODE)) {
            return System.identityHashCode(proxy);
        }
        if (method.getDeclaringClass().equals(Object.class)) {
            try {
                return method.invoke((Object)this.stmt, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        if (method.equals(STATEMENT_IS_CLOSED) || method.equals(FIREBIRDSTATEMENT_IS_CLOSED)) {
            return this.isClosed();
        }
        if (this.isClosed() && !method.equals(STATEMENT_CLOSE)) {
            throw new FBSQLException("Statement already closed", "26000");
        }
        try {
            if (method.equals(STATEMENT_CLOSE)) {
                if (!this.isClosed()) {
                    this.handleClose();
                }
                return null;
            }
            if (method.equals(GET_CONNECTION)) {
                return this.owner.getProxy();
            }
            return method.invoke((Object)this.stmt, args);
        }
        catch (InvocationTargetException ite) {
            Throwable inner = ite.getTargetException();
            if (inner instanceof SQLException) {
                this.owner.statementErrorOccurred(this, (SQLException)inner);
            }
            throw inner;
        }
        catch (SQLException se) {
            this.owner.statementErrorOccurred(this, se);
            throw se;
        }
    }

    protected Statement getProxy() {
        return this.proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClose() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        try {
            this.stmt.close();
        }
        finally {
            this.owner.forgetStatement(this);
            this.stmt = null;
            this.proxy = null;
        }
    }

    protected void close() throws SQLException {
        this.handleClose();
    }

    public boolean isClosed() {
        return this.proxy == null || this.stmt == null;
    }
}

