/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.math.BigDecimal;
import java.sql.SQLException;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

public class FBBooleanField
extends FBField {
    FBBooleanField(XSQLVAR field, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(field, dataProvider, requiredType);
    }

    @Override
    public byte getByte() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return (byte)(this.getBoolean() ? 1 : 0);
    }

    @Override
    public short getShort() throws SQLException {
        return this.getByte();
    }

    @Override
    public int getInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return this.getBoolean() ? 1 : 0;
    }

    @Override
    public long getLong() throws SQLException {
        return this.getInt();
    }

    @Override
    public float getFloat() throws SQLException {
        return this.getInt();
    }

    @Override
    public double getDouble() throws SQLException {
        return this.getInt();
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        if (this.isNull()) {
            return BIGDECIMAL_NULL_VALUE;
        }
        return this.getBoolean() ? BigDecimal.ONE : BigDecimal.ZERO;
    }

    @Override
    public String getString() throws SQLException {
        if (this.isNull()) {
            return STRING_NULL_VALUE;
        }
        return this.getBoolean() ? "true" : "false";
    }

    @Override
    public boolean getBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.field.decodeBoolean(this.getFieldData());
    }

    @Override
    public void setByte(byte value) throws SQLException {
        this.setBoolean(value != 0);
    }

    @Override
    public void setShort(short value) throws SQLException {
        this.setBoolean(value != 0);
    }

    @Override
    public void setInteger(int value) throws SQLException {
        this.setBoolean(value != 0);
    }

    @Override
    public void setLong(long value) throws SQLException {
        this.setBoolean(value != 0L);
    }

    @Override
    public void setFloat(float value) throws SQLException {
        this.setBoolean(value != 0.0f);
    }

    @Override
    public void setDouble(double value) throws SQLException {
        this.setBoolean(value != 0.0);
    }

    @Override
    public void setBigDecimal(BigDecimal value) throws SQLException {
        if (value == null) {
            this.setNull();
        } else {
            this.setBoolean(value.compareTo(BigDecimal.ZERO) != 0);
        }
    }

    @Override
    public void setString(String value) throws SQLException {
        if (value == null) {
            this.setNull();
        } else {
            String trimmedValue = value.trim();
            this.setBoolean(trimmedValue.equalsIgnoreCase("true") || trimmedValue.equalsIgnoreCase("Y") || trimmedValue.equalsIgnoreCase("T") || trimmedValue.equalsIgnoreCase("1"));
        }
    }

    @Override
    public void setBoolean(boolean value) throws SQLException {
        this.setFieldData(this.field.encodeBoolean(value));
    }
}

