/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl;

import java.sql.SQLException;
import java.util.Objects;
import java.util.TimeZone;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.ng.BlobConfig;
import org.firebirdsql.gds.ng.FbBlob;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.IConnectionProperties;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.TransactionState;
import org.firebirdsql.logging.LoggerFactory;

public final class GDSHelper {
    @Deprecated
    public static final int DEFAULT_BLOB_BUFFER_SIZE = 16384;
    private final FbDatabase database;
    private FbTransaction transaction;
    private TimeZone sessionTimeZone;

    public GDSHelper(FbDatabase database) {
        this.database = Objects.requireNonNull(database, "database");
    }

    public FbTransaction getCurrentTransaction() {
        try (LockCloseable ignored = this.withLock();){
            FbTransaction fbTransaction = this.transaction;
            return fbTransaction;
        }
    }

    public void setCurrentTransaction(FbTransaction transaction) {
        try (LockCloseable ignored = this.withLock();){
            this.transaction = transaction;
        }
    }

    public FbDatabase getCurrentDatabase() {
        return this.database;
    }

    public IConnectionProperties getConnectionProperties() {
        return this.database.getConnectionProperties();
    }

    public int getDialect() {
        return this.database.getConnectionDialect();
    }

    public FbStatement allocateStatement() throws SQLException {
        return this.database.createStatement(this.getCurrentTransaction());
    }

    public boolean inTransaction() {
        try (LockCloseable ignored = this.withLock();){
            boolean bl = this.transaction != null && this.transaction.getState() == TransactionState.ACTIVE;
            return bl;
        }
    }

    public void executeImmediate(String statement) throws SQLException {
        this.database.executeImmediate(statement, this.getCurrentTransaction());
    }

    public FbBlob openBlob(long blobId, BlobConfig blobConfig) throws SQLException {
        FbBlob blob = this.database.createBlobForInput(this.getCurrentTransaction(), blobConfig, blobId);
        blob.open();
        return blob;
    }

    public FbBlob createBlob(BlobConfig blobConfig) throws SQLException {
        FbBlob blob = this.database.createBlobForOutput(this.getCurrentTransaction(), blobConfig);
        blob.open();
        return blob;
    }

    public FbTransaction startTransaction(TransactionParameterBuffer tpb) throws SQLException {
        FbTransaction transaction = this.database.startTransaction(tpb);
        this.setCurrentTransaction(transaction);
        return transaction;
    }

    public void detachDatabase() throws SQLException {
        this.database.close();
    }

    public void cancelOperation() throws SQLException {
        this.database.cancelOperation(3);
    }

    public String getDatabaseProductName() {
        return this.database.getServerVersion().getServerName();
    }

    public String getDatabaseProductVersion() {
        return this.database.getServerVersion().getFullVersion();
    }

    public int getDatabaseProductMajorVersion() {
        return this.database.getServerVersion().getMajorVersion();
    }

    public int getDatabaseProductMinorVersion() {
        return this.database.getServerVersion().getMinorVersion();
    }

    public int compareToVersion(int major, int minor) {
        int differenceMajor = this.getDatabaseProductMajorVersion() - major;
        if (differenceMajor == 0) {
            return this.getDatabaseProductMinorVersion() - minor;
        }
        return differenceMajor;
    }

    public String getUserName() {
        return this.database.getConnectionProperties().getUser();
    }

    @Deprecated
    public String getIscEncoding() {
        return this.database.getEncodingFactory().getDefaultEncodingDefinition().getFirebirdEncodingName();
    }

    public TimeZone getSessionTimeZone() {
        if (this.sessionTimeZone == null) {
            return this.initSessionTimeZone();
        }
        return this.sessionTimeZone;
    }

    private TimeZone initSessionTimeZone() {
        String sessionTimeZoneName = this.database.getConnectionProperties().getSessionTimeZone();
        if (sessionTimeZoneName == null || "server".equalsIgnoreCase(sessionTimeZoneName)) {
            this.sessionTimeZone = TimeZone.getDefault();
            return this.sessionTimeZone;
        }
        TimeZone timeZone = TimeZone.getTimeZone(sessionTimeZoneName);
        if ("GMT".equals(timeZone.getID()) && !"GMT".equalsIgnoreCase(sessionTimeZoneName)) {
            LoggerFactory.getLogger(this.getClass()).warnf("TimeZone fallback to GMT from %s; possible cause: value of sessionTimeZone unknown in Java. Time and Timestamp values may yield unexpected values. Consider setting a different value for sessionTimeZone.", (Object)sessionTimeZoneName);
        }
        this.sessionTimeZone = timeZone;
        return this.sessionTimeZone;
    }

    public LockCloseable withLock() {
        return this.database.withLock();
    }
}

